<?php

namespace App\Http\Controllers;
use App\OrderedDocuments;
use App\SystemUsers;
use App\UserLogs;
use Illuminate\Http\Request;
use Session;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Storage;
use App\Models\User;


class DashboardController extends Controller
{
    public function __construct() {
      
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //Get all clients and group them into plans and count the number of clients in each plan
        $clients = DB::table('clients')
            ->select('clients.*', 'packages.data_package as package_name', 'packages.price as package_price')
            ->join('packages', 'clients.plan', '=', 'packages.id')
            ->get();
            
        $plans = [];
        foreach($clients as $client){
            if(!array_key_exists($client->package_name, $plans)){
                $plans[$client->package_name] = 1;
            }else{
                $plans[$client->package_name] += 1;
            }
        }

        //Get all clients and group them into plans and sum the total amount of money from each plan
        $clients = DB::table('clients')
            ->select('clients.*', 'packages.data_package as package_name', 'packages.price as package_price')
            ->join('packages', 'clients.plan', '=', 'packages.id')
            ->get();

        $plans_total = [];

        foreach($clients as $client){
            if(!array_key_exists($client->package_name, $plans_total)){
                $plans_total[$client->package_name] = $client->package_price;
            }else{
                $plans_total[$client->package_name] += $client->package_price;
            }
        }

        $total_clients = count($clients);
        $total_revenue = array_sum($plans_total);

        //weekly payment
        $weekly_payment = DB::table('payments')->where('created_at', '>=', Carbon::now()->subDays(7))->sum('amount');
        $monthly_payment = DB::table('payments')->where('created_at', '>=', Carbon::now()->subDays(30))->sum('amount');

        $data = [
            'total_clients' => $total_clients,
            'total_revenue' => $total_revenue,
            'plans' => $plans,
            'plans_total' => $plans_total,
            'weekly_payment' => $weekly_payment,
            'monthly_payment' => $monthly_payment
        ];

        return view('dashboard', $data);
        //return view('dashboard');
    }    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function settings(){
        $admin_info = User::where('user_role', 'admin')->first();
        if ($admin_info === null) {
            $admin_info = new User;
        }
        return view('settings', ['admin' => $admin_info]);
    }

    public function adminInfoUpdate(Request $request){
        //add admin info if not exists
        $admin_info = User::where('user_role', 'admin')->first();
        if($admin_info == null){
            $admin_info = new User;
            $admin_info->user_role = 'admin';
        }

        $admin_info->name = $request->name;
        $admin_info->email = $request->email;
        $admin_info->phone_number = $request->phone;
        $admin_info->password = $request->password;

        $admin_info->save();

        return response()->json(['status' => 'success', 'message' => 'Admin info updated successfully']);
    }
}