<?php

namespace App\Http\Controllers;
use App\SystemUsers;
use App\Designation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $login_error = Session::get('current_user.login_error');
        $data = [
            'login_error' => $login_error,
        ];
        return view('login.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->session()->forget('current_user');
        $request->session()->flush();
        $request->session()->regenerate(true);
        $username = $request->emailaddress;
        $password = md5($request->password);
        $privillage_keys = [];
        $system_user = SystemUsers::where('emailaddress', $username)->where('password', $password)->first();
        
        if ($system_user) {
            $privillages = json_decode($system_user->privillages);
            $collection = collect($privillages)->map(function ($privillage) {
                return $privillage->id;
            })->toArray();

            $privillage_keys = array_merge($collection, $privillage_keys);
         
            $designation = Designation::find((int) $system_user->designation);
            if ($designation) {
                $privillages = json_decode($designation->privillages);
                $collection = collect($privillages)->map(function ($privillage) {
                    return $privillage->id;
                })->toArray();

                $privillage_keys = array_merge($collection, $privillage_keys);
            }
            
            $programs = [];
            if ($system_user->programs) {
                $programs = json_decode($system_user->programs);
            }
            
            $firstname = $system_user->firstname;
            $lastname = $system_user->lastname;
            $request->session()->regenerate(true);
            $request->session()->put('current_user.access_level', $system_user->designation);
            $request->session()->put('current_user.merchant_id', $system_user->merchant_id);
            $request->session()->put('current_user.user_id', $system_user->id);
            $request->session()->put('current_user.name', $firstname . ' ' . $lastname);
            $request->session()->put('current_user.privillages', $system_user->privillages);
            $request->session()->put('current_user.programs', $programs);
            $request->session()->put('current_user.privillages.keys', $privillage_keys);
            return redirect('/dashboard');
        } else {
            $request->session()->put('current_user.login_error', 'Username or password is incorrect!');
            return redirect('/login');
        }
    }

    public function logOut(Request $request) {
        $request->session()->forget('current_user');
        $request->session()->flush();
        $request->session()->regenerate(true);
        return 'success';
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}