<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Wallet;
use App\Models\Payment;
use App\Models\Client;
use App\Models\Renew;
use App\Models\Package;
use App\Models\User;
use App\Models\Sms;
use App\Models\SmsHistory;

class PaymentController extends Controller
{
    public function makePayment(Request $request)
    {
        // return response()->json($request->all());
        // Find the wallet associated with the client or create a new one
        try {
            if($request->payment_type == 'late_payment'){
              //create a renew and payment
              $this->latePayment($request);
            }else{
                $this->earlyPayment($request);
            }

            // return response()->json(['payment' => $payment, 'wallet' => $wallet]);
        } catch (\Exception $e) {
            return response()->json(['error' => 'An error occurred while making the payment: ' . $e->getMessage()], 500);
        }
    }

    public function latePayment($request){
        $client = Client::findOrFail($request->client_id);

        $package = Package::findOrFail($request->package_id);
    
        $renew_date = \Carbon\Carbon::now()->format('d M Y');

        // Create a new Renew instance and save it
        $renew = new Renew([
            'client_id' => $request->client_id,
            'package_id' => $request->package_id,
            'renew_date' => $renew_date,
            'expiry_date' => \Carbon\Carbon::parse($renew_date)->addDays(29)->format('d M Y'),
        ]);

        $renew->save();

        $payment = new Payment([
            'amount' => $package->price,
            'client_id' => $request->client_id,
            'payment_transaction_id' => $renew->id,
            'payment_type' => $request->payment_type,
            'payment_reason' => 'renewal',
            'payment_date' => \Carbon\Carbon::now(),
        ]);

        $payment->save();

        $client->expiry_date = $renew->expiry_date;
        $client->plan = $request->package_id;
        $client->status = 'Active';

        $client->save();

        $client_phone_number = $client->phone_number;
        $client_phone_number = explode(',', $client_phone_number);

        // foreach ($client_phone_number as $phone_number) {
        //     $this->send_sms('The subscription for ' . $client->account_username . ' has been renewed. The new expiry date is ' . $renew->expiry_date, $phone_number);
        // }

        //Get the admin user details and send sms to his phone number
        $admin = User::where('user_role', 'admin')->first();
        // $this->send_sms('The subscription for ' . $client->account_username . ' has been renewed. The new expiry date is ' . $renew->expiry_date, $admin->phone_number);
        $phoneNumbers = explode(',', $admin->phone_number);

        // foreach ($phoneNumbers as $phoneNumber) {
        //     $this->send_sms('The subscription for ' . $client->account_username . ' has been renewed. The new expiry date is ' . $renew->expiry_date, trim($phoneNumber));
        // }

        // Get SMS where sms feature is 1
        $sms = Sms::where('sms_feature', '1')->get()[0];


        foreach ($phoneNumbers as $phoneNumber) {
            // Construct the message
            $message = "Date: " . date('jS F Y') . "\n";
            $message .= "Received from: " . $client->account_username . "\n";
            $message .= "The sum of: " . $package->price . "\n";
            $message .= "Being the payment for: " .  $package->data_package . "\n"; 
            $message .= "Expiry date: " . $renew->expiry_date . "\n";
            $message .= "Thank you";

            // Send the SMS
            $this->send_sms($message, trim($phoneNumber));
            $smsHistory = new SmsHistory;
            $smsHistory->phone_number = $phoneNumber;
            $smsHistory->message = $message;
            $smsHistory->status = 'sent';
            $smsHistory->save();
        }
        return response()->json(['message' => 'Subscription renewed successfully']);
    }

    public function earlyPayment($request){
        $wallet = Wallet::firstOrCreate(
            ['client_id' => $request->client_id],
            ['balance' => 0, 'last_renewal_date' => \Carbon\Carbon::now(), 'expiration_date' => \Carbon\Carbon::now()->addYear(), 'active' => true]
        );

        // Record the payment and update the wallet balance
        // $payment = new Payment([
        //     'wallet_id' => $wallet->id,
        //     'amount' => $request->amount,
        //     'transaction_type' => $request->payment_type,
        //     'payment_type' => 'renewal',
        //     'payment_date' => \Carbon\Carbon::now(),
        // ]);

        // $payment->save();

        $wallet->balance += $request->amount;
        // $wallet->last_renewal_date = \Carbon\Carbon::now();
        // $wallet->expiration_date = \Carbon\Carbon::parse($wallet->last_renewal_date)->addYear();
        
        $wallet->save();
    }
}
