<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Models\Sms;
use App\Models\Client;
use App\Models\Station;
use App\Models\SmsHistory;
use App\Models\User;

class SMSController extends Controller
{
     public function send_sms($msg, $contact)
	{
		$sender = 'NERVE TECH';

		$sms = urlencode($msg);

		$phone = $contact;
	
		$url = "http://powertxtgh.com/access.php?company=ALOT&ccode=ALT101&sender=Nerve-Tech&message=$sms&recipient=$contact";

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_POST, false); //enable post
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); //disable ssl
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //enable response
		curl_setopt($ch, CURLOPT_ENCODING, '');
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));//add parameters

		$server_output = curl_exec($ch); //execute request and get response

		return 1;
	}

    // Controller methods will go here
    public function index(){
        //get all clients
        $clients = Client::all();

        //get the sms from the database
        $sms = Sms::all();

        //get all nodes
        $stations = Station::all();

        $sms_features = [
            "1" => "Renew",
            "2" => "Auto Reminder - 1 day",
            "3" => "Auto Reminder - 1 week",
            "4" => "Early Payment",
            "5" => "Late Payment",
            "6" => "Service Interruption",
            "7" => "Service Restored",
            "8" => "Payment for Lease Installation",
            "9" => "Full Installation",
            "10" => "Welcome Client"
        ];

        return view('sms', ['sms' => $sms,'sms_features'=>$sms_features,'stations'=>$stations,'clients'=>$clients]);
    }

    public function smsStore(Request $request){
        try {
            $sms_type = $request->input('smsType');
            $sms_content = $request->input('content');
            $sms_feature = $request->input('feature');

            $sms = new Sms;
            $sms->sms_type = $sms_type;
            $sms->sms_content = $sms_content;
            $sms->sms_feature = $sms_feature;
            $sms->save();

            return response()->json(['success' => 'SMS sent successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to send SMS: ' . $e->getMessage()], 500);
        }
    }

    public function smsUpdate(Request $request,$id){
        try {
            // return response()->json($request->all());
            $sms_id = $id;
            $sms_type = $request->input('smsType');
            $sms_content = $request->input('content');
            $sms_feature = $request->input('Editfeature');

            $sms = Sms::find($sms_id);
            $sms->sms_type = $sms_type;
            $sms->sms_content = $sms_content;
            $sms->sms_feature = $sms_feature;
            $sms->save();

            return response()->json(['success' => 'SMS updated successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to update SMS: ' . $e->getMessage()], 500);
        }
    }

    //get the sms by id and return back to the view using response
    public function smsEdit($id){
        $sms = Sms::find($id);
        return response()->json($sms);
    }

    public function smsRemove($id){
        try {
            $sms = Sms::find($id);
            $sms->delete();
            return response()->json(['success' => 'SMS deleted successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Failed to delete SMS: ' . $e->getMessage()], 500);
        }
    }

    public function smsSendToAllClient(Request $request){
        try {
            $smsMessage = $request->input('message');
            $group = $request->input('group');
            $client = $request->input('client');

            //check if smsMessage is empty
            if(empty($smsMessage)){
                return response()->json(['error' => 'SMS message cannot be empty'], 500);
            }

            if($client != null){
                $client = Client::find($client);
                $phone_number = explode(",",$client->phone_number);

                foreach ($phone_number as $phone) {
                    $this->send_sms($smsMessage,$phone);

                    //save to smshistory
                    $smsHistory = new SmsHistory;
                    $smsHistory->phone_number = $phone;
                    $smsHistory->message = $smsMessage;
                    $smsHistory->status = 'sent';
                    $smsHistory->save();


                }

                return response()->json(['success' => 'SMS sent successfully']);
            }

            if($group == '0'){

                $clients = Client::all();

                foreach ($clients as $key => $client) {
                    $phone_number = explode(",",$client->phone_number);
                    if($key == 0){
                        foreach ($phone_number as $phone) {
                            $this->send_sms($smsMessage,$phone);
                            $smsHistory = new SmsHistory;
                            $smsHistory->phone_number = $phone;
                            $smsHistory->message = $smsMessage;
                            $smsHistory->status = 'sent';
                            $smsHistory->save();
                        }
                    }
                }

            }{
                $clients = Client::where('node',$group)->get();

                foreach ($clients as $key => $client) {
                    $phone_number = explode(",",$client->phone_number);
                    //if($key == 0){
                        foreach ($phone_number as $phone) {
                            $this->send_sms($smsMessage,$phone);
                            $smsHistory = new SmsHistory;
                            $smsHistory->phone_number = $phone;
                            $smsHistory->message = $smsMessage;
                            $smsHistory->status = 'sent';
                            $smsHistory->save();
                        }
                    //}
                }

                $admin = User::where('user_role','admin')->first();
                $phone_number = explode(",",$admin->phone_number);
                foreach ($phone_number as $phone) {
                    $this->send_sms($smsMessage,$phone);
                    $smsHistory = new SmsHistory;
                    $smsHistory->phone_number = $phone;
                    $smsHistory->message = $smsMessage;
                    $smsHistory->status = 'sent';
                    $smsHistory->save();
                }
            }
            
            return response()->json(['success' => 'SMS sent successfully']);
        } catch (\Exception $e) {
            // Log the exception message
            Log::error('Error sending SMS: ' . $e->getMessage());

            // Return a response with the error message
            return response()->json(['error' => 'Error sending SMS: ' . $e->getMessage()], 500);
        }
    }


    public function smsSendToClient(Request $request){
        try {
            $smsMessage = $request->input('message');
            $client_id = $request->input('client_id');
            $client = Client::find($client_id);
            $phone_number = explode(",",$client->phone_number);
            foreach ($phone_number as $phone) {
                $this->send_sms($smsMessage,$phone);
                $smsHistory = new SmsHistory;
                $smsHistory->phone_number = $phone;
                $smsHistory->message = $smsMessage;
                $smsHistory->status = 'sent';
                $smsHistory->save();
            }

            //send to admin also
            //get the admin phone number
            $admin = User::where('user_role','admin')->first();
            $phone_number = explode(",",$admin->phone_number);
            foreach ($phone_number as $phone) {
                $this->send_sms($smsMessage,$phone);
                $smsHistory = new SmsHistory;
                $smsHistory->phone_number = $phone;
                $smsHistory->message = $smsMessage;
                $smsHistory->status = 'sent';
                $smsHistory->save();
            }

            //$this->send_sms($smsMessage,'0506596743');

            return response()->json(['success' => 'SMS sent successfully']);
        } catch (\Exception $e) {
            // Log the exception message
            Log::error('Error sending SMS: ' . $e->getMessage());

            // Return a response with the error message
            return response()->json(['error' => 'Error sending SMS: ' . $e->getMessage()], 500);
        }
    }


    //smsHistory
    public function smsHistory(){
        $sms = SmsHistory::all();
        return view('smshistory', ['sms' => $sms]);
    }


    public function searchSmsHistory(){
        $search = \Request::get('search');
        $sms = SmsHistory::where('phone_number','like','%'.$search.'%')
                            ->orWhere('message','like','%'.$search.'%')
                            ->orWhere('status','like','%'.$search.'%')
                            ->get();
        return response()->json($sms);
    }
    

}
