<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Station;
use Ramsey\Uuid\Uuid;
use App\Models\Client;
use App\Models\User;
use App\Models\SmsHistory;



class StationController extends Controller
{
      private function sendSms($msg, $contact)
	{
		$sender = 'NERVE TECH';

		$sms = urlencode($msg);

		$phone = $contact;
	
		$url = "http://powertxtgh.com/access.php?company=ALOT&ccode=ALT101&sender=Nerve-Tech&message=$sms&recipient=$contact";

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_POST, false); //enable post
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); //disable ssl
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //enable response
		curl_setopt($ch, CURLOPT_ENCODING, '');
		// curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));//add parameters

		$server_output = curl_exec($ch); //execute request and get response

		return 1;
	}
    // public function index(){

    //     $data = Station::all();  

    //     $baseStations = array();

    //     foreach ($data as $node) {
    //         $baseStationId = $node['base_station'];

    //         if ($baseStationId === null) {
    //             // This node is a base station
    //             $baseStations[$node['node_uuid']] = array(
    //                 'node_name' => $node['node_name'],
    //                 'children' => array(),
    //             );
    //         } else {
    //             // This node is a child
    //             $baseStations[$baseStationId]['children'][] = array(
    //                 'node_name' => $node['node_name'],
    //                 'status' => $node['status'],
    //             );
    //         }
    //     }


    //     return response()->json($baseStations);
        
    //     return response()->json($stations);

    //     return view('station', ['nodes' => $stations]);
    // }    

    // public function index(){
    //     $data = Station::all();
        
    //     return view('station', ['nodes'=>$data]);
        
    // }

    public function index()
    {
        // Fetch all nodes
        $stations = Station::all();

        // Build hierarchy
        $hierarchy = $this->buildHierarchy($stations);

        // return response()->json(['data' => $hierarchy], 200);
        return view('station', ['nodes' => $stations, 'stations'=>$hierarchy]);
    }

    private function buildHierarchy($stations, $parentId = null)
    {
        $result = [];

        foreach ($stations as $station) {
            if ($station->base_station == $parentId) {
                $children = $this->buildHierarchy($stations, $station->node_uuid);

                if ($children->isNotEmpty()) {
                    $station->children = $children;
                }

                $result[] = $station;
            }
        }

        return collect($result);
    }

  

    public function addNode(Request $request){
        // return response()->json($request->all());
        try {
            //validate the input manually
            if(!$request->node_name || !$request->location || !$request->status){
                return response()->json(['message' => 'All fields are required'], 400);
            }

            //check if node is already added
            $node = Station::where('node_name', $request->node_name)->first();

            if($node){
                return response()->json(['message' => 'Node already exists'], 400);
            }

            // Create a new node
            $node = new Station;
            $node->node_uuid = Uuid::uuid4()->toString();
            $node->node_name = $request->node_name;
            $node->location = $request->location;
            // $node->node_type = $request->node_type;
            // if($request->node_type == 'normal'){
                $node->base_station = $request->base_station;
            // } 
            $node->status = $request->status;
            $node->save();

            return response()->json(['message' => 'Node added successfully'], 200);
        } catch (\Exception $e) {
            // Return the error message
            return response()->json(['message' => 'Failed to add node: ' . $e->getMessage()], 500);
        }
    }

    public function deleteNode(Request $request){
        try {
            // Find the node by its ID
            $node = Station::findOrFail($request->id);

            // Delete the node
            $node->delete();

            return response()->json(['message' => 'Node deleted successfully'], 200);
        } catch (\Exception $e) {
            // Return the error message
            return response()->json(['message' => 'Failed to delete node: ' . $e->getMessage()], 500);
        }
    }

    public function editNode(Request $request){
        try {
            // Find the node by its ID
            $node = Station::findOrFail($request->id);

            return response()->json($node);
        } catch (\Exception $e) {
            // Return the error message
            return response()->json(['message' => 'Failed to edit node: ' . $e->getMessage()], 500);
        }
    }

    private function getNodeUuids($nodes) {
        $nodeUuids = [];

        foreach ($nodes as $node) {
            $nodeUuids[] = $node->node_uuid;

            // $node->status = $status;

            if ($node->children) {
                $nodeUuids = array_merge($nodeUuids, $this->getNodeUuids($node->children));
            }
        }

        return $nodeUuids;
    }

    public function updateNode(Request $request){
        try {
            // Find the node by its ID
            $node = Station::findOrFail($request->id);

            // Update the node
            $node->node_name = $request->node_name;
            $node->location = $request->location;
            $node->base_station = $request->base_station;

            $admin = User::where('user_role', 'admin')->first();
            $adminPhoneNumbers = explode(',', $admin->phone_number);

            // return response()->json(['node_status'=>$node->status,'request_status'=>$request->status], 200);
            if($node->status != $request->status){
                // return response()->json(['message' => 'Test 12'], 200);
                 // check if node is a parent and get it sub nodes and get all the children of the hierarchy
                // if($node->base_station == null){
                $children = $this->buildHierarchy(Station::all(), $node->node_uuid);
                //return response()->json($children);
                
                $nodeUuids = $this->getNodeUuids($children);

                //push the node uuid to the array
                $nodeUuids[] = $node->node_uuid;

                //get all the clients with the node uuid and send them a message
                $clients = Client::whereIn('node', $nodeUuids)->get();

                if ($request->status == 'offline') {
                    // $message = 'Dear client, we are experiencing some technical difficulties ...';
                    //get sms message and send to the clients
                    $sms = \App\Models\Sms::where('sms_type','Service Interruption')->first();

                    $message = $sms->sms_content;

                    // return response()->json($message);

                    foreach ($adminPhoneNumbers as $key => $adminPhoneNumber) {
                            $this->sendSms($message,$adminPhoneNumber);
                            $smsHistory = new SmsHistory;
                            $smsHistory->phone_number = $adminPhoneNumber;
                            $smsHistory->message = $message;
                            $smsHistory->status = 'sent';
                            $smsHistory->save();
                    }

                    foreach ($clients as $key => $client) {
        
                        //explode the phone number and send the message
                        $clientPhoneNumbers =  explode(',',$client->phone_number);
                        foreach ($clientPhoneNumbers as $key => $clientPhoneNumber) {
                                $this->sendSms($message,$clientPhoneNumber);
                                $smsHistory = new SmsHistory;
                                $smsHistory->phone_number = $clientPhoneNumber;
                                $smsHistory->message = $message;
                                $smsHistory->status = 'sent';
                                $smsHistory->save();
                        }
                    }
                }else{
                    // $message = 'Dear client, we are back online ...';
                    $sms = \App\Models\Sms::where('sms_type','Service Restored')->first();

                    $message = $sms->sms_content;

                    // return response()->json($message);

                     foreach ($adminPhoneNumbers as $key => $adminPhoneNumber) {
                         $this->sendSms($message,$adminPhoneNumber);
                            $smsHistory = new SmsHistory;
                            $smsHistory->phone_number = $adminPhoneNumber;
                            $smsHistory->message = $message;
                            $smsHistory->status = 'sent';
                            $smsHistory->save();
                    }

                    foreach ($clients as $key => $client) {
                        
                        $phoneNumbers =  explode(',',$client->phone_number);
                        foreach ($phoneNumbers as $key => $phoneNumber) {
                                $this->sendSms($message,$phoneNumber);
                                $smsHistory = new SmsHistory;
                                $smsHistory->phone_number = $phoneNumber;
                                $smsHistory->message = $message;
                                $smsHistory->status = 'sent';
                                $smsHistory->save();
                        }
                    }
                }

            }

            $node->status = $request->status;

            //return response()->json(["clients"=>$clients,"nodeUUids"=>$nodeUuids,"children"=>$children]);
            
            $node->save();

            return response()->json(['message' => 'Node updated successfully'], 200);
        } catch (\Exception $e) {
            // Return the error message
            return response()->json(['message' => 'Failed to update node: ' . $e->getMessage()], 500);
        }
    }

    public function defineMainNode(Request $request){
        // return response()->json($request->all());
        try {
            //check for the old main node and set it to null
            $old_main_node = Station::where('main_base_station', 'main')->first();

            if($old_main_node){
                $old_main_node->main_base_station = null;
                $old_main_node->save();
            }

            // Find the node by its ID
            $node = Station::where('node_uuid', $request->main_base_station)->firstOrFail();

            // Update the node
            $node->main_base_station = 'main';
            $node->save();

            return response()->json(['message' => 'Main node defined successfully'], 200);
        } catch (\Exception $e) {
            // Return the error message
            return response()->json(['message' => 'Failed to define main node: ' . $e->getMessage()], 500);
        }
    }
}

