<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('transaction_details')) {
            Schema::create('transaction_details', function (Blueprint $table) {
                $table->increments('id');
                $table->string('transaction_id');
                $table->string('amount');
                $table->string('api_user_id');
                $table->string('balance');
                $table->string('balancebf');
                $table->string('bank_account');
                $table->string('client_id');
                $table->string('company_id');
                $table->string('customer_charge');
                $table->string('dates');
                $table->string('fetched');
                $table->string('merchant_amount');
                $table->string('merchant_charge');
                $table->string('product_id');
                $table->string('product_type');
                $table->string('receiptno');
                $table->string('sold_by');
                $table->string('telegramed');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transaction_details');
    }
}
