@extends('layouts.main')

@section('title', 'Nerve Tech Client Management System')

@section('content')  

    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">
    
      <!--  Main wrapper -->
      <div class="" style="padding-top: calc(70px + 15px)">
        
       
        <div class="container-fluid">
          <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">Payments</h5>
                    </div>
                    <div>

                      <!-- Button trigger modal -->
                      <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addClientModal">
                        Part Replacement
                      </button>

                      <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addClientModal">
                        Record Expenditure
                      </button>

                      </div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12">
                  
                </div>
                <div class="col-lg-12">
                  
                </div>
              </div>
            </div>
          </div>
           
          <div class="row">
            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <div class="row">
                    <div class="col-md-6">
                      <h5 class="card-title fw-semibold mb-4">Payments</h5>
                    </div>
                    <div class="col-md-6 d-flex justify-content-end">
                      <form id="searchForm" class="mb-3">

                        <div class="input-group">
                        </div>

                        <div class="row">
                          <!-- Start date -->
                          <div class="col-md-4">
                            <label for="start_payment_date">Start Payment Date:</label>
                            <input type="date" id="start_payment_date" name="start_payment_date" class="form-control">
                          </div>

                          <!-- End date -->
                          <div class="col-md-4">
                            <label for="end_payment_date">End Payment Date:</label>
                            <input type="date" id="end_payment_date" name="end_payment_date" class="form-control">
                          </div>

                          <!-- Search -->
                          <div class="col-md-4">
                            <label for="search">Search Payments:</label>
                            <input type="text" id="search" name="search" class="form-control" placeholder="Search payments" value="{{ request()->get('search') }}">
                          </div>
                        </div>

                        <!-- Button -->
                        <div class="row mt-3">
                          <div class="col-md-12 d-flex justify-content-end">
                            <button class="btn btn-primary">Search</button>
                          </div>
                        </div>
                      </form>
                    </div>
                  </div>

                  <div class="table-responsive" >
                    <table class="table text-nowrap mb-0 align-middle">
                      <thead class="text-dark fs-4">
                        <tr>
                          <th class="border-bottom-0">
                              <input type="checkbox" id="selectAll">
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Id</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Client Name</h6>
                          </th>
                          {{-- <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">GPS</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Email</h6>
                          </th> --}}
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Payment Amount</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Payment Type</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Payment Date</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Action</h6>
                          </th>

                        </tr>
                      </thead>
                      <tbody>
                        @foreach($payments as $key => $payment)
                        <tr>
                          <td>
                            <input type="checkbox" class="select">
                          </td>
                          <td>
                            <h6 class="mb-0">{{ $key + 1 }}</h6>
                          </td>
                          <td>
                            <h6 class="mb-0">{{ $payment->client_name }}</h6>
                          </td>
                         
                          <td>
                            <h6 class="mb-0">{{ $payment->amount }}</h6>
                          </td>

                          <td>
                            <h6 class="mb-0">{{ $payment->transaction_type == "early_payment" ? 'Early Payment':'Data Subscription' }}</h6>
                          </td>

                          <td>
                            <h6 class="mb-0">{{ $payment->payment_date }}</h6>

                          </td>

                          {{-- <td>
                            <h6 class="mb-0">{{ $payment->status }}</h6>
                          </td> --}}

                          <td>
                            <a href="#" class="btn btn-primary">Print</a>
                            <a href="#" class="btn btn-primary">Send</a>
                          </td>
                        </tr>
                        @endforeach
                        
                      </tbody>
                    </table>
                  </div>
                  <br>
                  <br>

                   <div class="d-flex align-items-center justify-content-end">
                    <nav aria-label="Page navigation example">
                      <ul class="pagination">
                        <li class="page-item" style="margin-right: 20px;">
                          <input type="number" id="page-number-input" class="form-control" min="1" max="{{ $total_pages }}" value="{{ $page_number }}">
                        </li>
                        <li class="page-item" style="margin-right: 20px;">
                          <button class="btn btn-primary" onclick="goToPage()">Go</button>
                        </li>
                        <li class="page-item">
                          <span class="page-link">{{ $page_number }} of {{ $total_pages }}</span>
                        </li>
                      </ul>
                    </nav>
                  </div>
                  
                </div>
              </div>
            </div>
          </div>    
        </div>    
      </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> 


    <script>

        page_number = 1;

        page_number = <?php echo $page_number; ?>;

        $(document).ready(function() {
          $('#searchForm').on('submit', function(e) {
            e.preventDefault();
            const searchValue = $('input[name="search"]').val();

            const start_payment_date = $('input[name="start_payment_date"]').val();
            const end_payment_date = $('input[name="end_payment_date"]').val();

            //console.log(payment_date);

            // Redirect to the search page
            $.ajax({
              url: `{{ url('/search-finance') }}`,
              type: 'POST',
              data: {
                  search: searchValue,
                  //payment_date: payment_date,
                  start_payment_date: start_payment_date,
                  end_payment_date: end_payment_date,
                  _token: '{{ csrf_token() }}'
              },
              success: function(response) {
                  // Handle success here
                  console.log(response);

                  // display the search client in the table
                  let tableBody = '';

                  
                  response.payments.forEach((payment, index) => {
                    tableBody += `
                      <tr>
                        <td>
                          <input type="checkbox" class="select">
                        </td>
                        <td>
                          <h6 class="mb-0">${index + 1}</h6>
                        </td>
                        <td>
                          <h6 class="mb-0">${payment.account_username}</h6>
                        </td>
                        <td>
                          <h6 class="mb-0">${payment.amount}</h6>
                        </td>
                        <td>
                          <h6 class="mb-0">${payment.transaction_type == "early_payment" ? 'Early Payment':'Data Subscription'}</h6>
                        </td>

                        <td>
                          <h6 class="mb-0">${payment.payment_date}</h6>
                        </td>

                        <td>
                          <a href="#" class="btn btn-primary">Print</a>
                          <a href="#" class="btn btn-primary">Send</a>
                        </td>
                      </tr>
                    `;
                  });

                tableBody +=`
                  <tr style="opacity: 0;">
                    <!-- Dummy row -->
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    <td class="border-0"></td>
                    </tr><tr style="opacity: 0;">
                        <!-- Dummy row -->
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                    </tr>
                    <tr style="opacity: 0;">
                        <!-- Dummy row -->
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                    </tr>
                                    <tr style="opacity: 0;">
                        <!-- Dummy row -->
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                    </tr>
                                    <tr style="opacity: 0;">
                        <!-- Dummy row -->
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                    </tr>
                                    <tr style="opacity: 0;">
                        <!-- Dummy row -->
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                        <td class="border-0"></td>
                    </tr>
                  `;

                  $('tbody').html(tableBody);
              },
              error: function(err) {
                  // Handle error here
              }
          });

          
          });
        });

        function previousPage() {
          if (page_number > 1) {
            page_number--;
            window.location = `{{ url('/finance/${page_number}') }}`;
          }
        }

        function nextPage() {
          let total_pages = <?php echo json_encode($total_pages); ?>;
          if (total_pages > page_number) {
            page_number++;
            window.location = `{{ url('/finance/${page_number}') }}`;
          }
        }

        function goToPage() {
          var pageNumber = document.getElementById('page-number-input').value;
          var totalPages = {{ $total_pages }};
          
          if (pageNumber > totalPages) {
            pageNumber = totalPages;
          }
          
          window.location.href = `{{ url('/finance') }}/${pageNumber}`;
        }
    </script>

@endsection