@extends('layouts.main')

@section('title', 'Nerve Tech Client Management System')

@section('content') 
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">

      <!-- Sidebar Start -->
      <!--  Sidebar End -->
      <!--  Main wrapper -->
      <div class="" style="padding-top: calc(70px + 15px)">
        
        <!--  Header Start -->
        <!--  Header End -->    
        <div class="container-fluid">
          <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">Settings</h5>
                    </div>
                    <div>
                    
                    </div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12">
                 <div class="card w-100">
                <div class="card-body">

                    <div class="mb-3 mb-sm-0">
                        <h5 class="card-title fw-semibold">Admin Info</h5>
                    </div>

                    <br>

                     <form>
                        <div class="form-group">
    <label for="name">Name</label>
    <input type="text" class="form-control" id="name" name="name" value="{{ $admin->name }}">
</div>

<div class="form-group">
    <label for="email">Email</label>
    <input type="email" class="form-control" id="email" name="email" value="{{ $admin->email }}">
</div>

<div class="form-group">
    <label for="phone">Phone Number</label>
    <input type="tel" class="form-control" id="phone" name="phone" value="{{ $admin->phone_number }}">
</div>

                        <div class="form-group">
                          <label for="password">Password</label>
                          <input type="password" class="form-control" id="password" name="password">
                        </div>

                        <div class="form-group">
                          <label for="password_confirmation">Confirm Password</label>
                          <input type="password" class="form-control" id="password_confirmation" name="password_confirmation">
                        </div>
                        <br>
                        <br>
                        <button type="submit" id="adminInfoUpdate" class="btn btn-primary">Update</button>

                      </form>

                    </div>
                  </div>
                  
                </div>
                {{-- <div class="col-lg-12">
                  
                </div> --}}
              </div>
            </div>
          </div>
           
        </div>    
      </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

    <script>
    $(document).ready(function() {
      $('#adminInfoUpdate').click(function(e) {
        e.preventDefault();

        var name = $('#name').val();
        var email = $('#email').val();
        var phone = $('#phone').val();
        var password = $('#password').val();
        var password_confirmation = $('#password_confirmation').val();

        Swal.fire({
          title: 'Are you sure?',
          text: "You are about to update the admin details.",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, update it!'
        }).then((result) => {
          if (result.isConfirmed) {
            $.ajax({
              url: "{{ url('/admin-info-update') }}",
              type: 'post',
              data: {
                name: name,
                email: email,
                phone: phone,
                password: password,
                password_confirmation: password_confirmation,
                _token: "{{ csrf_token() }}"
              },
              success: function(response) {
                Swal.fire(
                  'Updated!',
                  'Admin details have been updated.',
                  'success'
                );
              },
              error: function(response) {
                Swal.fire(
                  'Error!',
                  'There was an error updating the details.',
                  'error'
                );
              }
            });
          }
        });
      });
    });
    </script>

@endsection