@extends('layouts.main')

@section('title', 'Nerve Tech Client Management System')

@section('content') 

  <div class="modal fade" id="addSMSModal" tabindex="-1" role="dialog" aria-labelledby="addSMSModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addSMSModalLabel">Add SMS</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="addSMSForm">
            <div class="form-group">
              <label for="smsType">SMS Description</label>
              <input type="text" class="form-control" id="smsType" name="smsType">
            </div>

            <!-- Feature that will use this sms message -->
            <div class="form-group">
              <label for="feature">Feature</label>
              <select class="form-select" id="feature" name="feature">
                <option selected disabled>--Select--</option>
                <option value="1">Renew</option>
                <option value="2">Auto Reminder - 1 day</option>
                <option value="3">Auto Reminder - 1 week</option>
                <option value="4">Early  Payment</option>
                <option value="5">Late  Payment</option>
                <option value="6">Service Interruption</option>
                <option value="7">Service Restored</option>
                <option value="8">Payment for Lease Installation</option>
                <option value="9">Full Installation</option>
                <option value="10">Welcome Client</option>
              </select>
            </div>

            <div class="form-group">
              <label for="content">Content</label>
              <textarea type="text" class="form-control" id="content" name="content"></textarea>
            </div>

            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary" id="addSMSSubmit">Submit</button>
            </div>
          </form>
        </div>
        
      </div>
    </div>
  </div>

  <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="editModalLabel">Edit SMS</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="editSMSForm">
            <div class="form-group">
              <label for="smsType">SMS Type</label>
              <input type="text" class="form-control" id="smsType" name="smsType">
            </div>

            <div class="form-group">
              <label for="Editfeature">Feature</label>
              <select class="form-select" id="Editfeature" name="Editfeature">
                <option selected disabled>--Select--</option>
                <option value="1">Renew</option>
                <option value="2">Auto Reminder - 1 day</option>
                <option value="3">Auto Reminder - 1 week</option>
                <option value="4">Early  Payment</option>
                <option value="5">Late  Payment</option>
                <option value="6">Service Interruption</option>
                <option value="7">Service Restored</option>
                <option value="8">Payment for Lease Installation</option>
                <option value="9">Full Installation</option>
              </select>
            </div>

            <div class="form-group">
              <label for="content">Content</label>
              <textarea type="text" class="form-control" id="content" name="content"></textarea>
            </div>

            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary" id="editSMSSubmit">Submit</button>
            </div>
          </form>
        </div>
        
      </div>
    </div>
  </div>

  <div class="modal fade" id="sendSMSModal" tabindex="-1" role="dialog" aria-labelledby="sendSMSModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="sendSMSModalLabel">Send SMS</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="sendSMSForm">

          <div class="form-group">
            <label for="choice">Choose:</label><br>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="choice" id="clientChoice" value="client" onclick="toggleFields()" checked>
              <label class="form-check-label" for="clientChoice">
                Client
              </label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="choice" id="groupChoice" value="group" onclick="toggleFields()" checked>
              <label class="form-check-label" for="groupChoice">
                Group
              </label>
            </div>
          </div>

          <script>
            function toggleFields() {
              var clientSelect = document.getElementById('client');
              var groupSelect = document.getElementById('group');
              var clientChoice = document.getElementById('clientChoice');
              clientSelect.disabled = !clientChoice.checked;
              groupSelect.disabled = clientChoice.checked;
            }
          </script>          

            <!-- Client that will receive the SMS -->
            <div class="form-group">
                <label for="client">Client</label>
                <select class="form-select" id="client" name="client" disabled>
                    <option selected disabled>--Select--</option>
                    @foreach($clients as $client)
                        <option value="{{ $client->id }}">{{ $client->account_username }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label for="group">Group</label>
                <select class="form-select" id="group" name="group" >
                    <option selected disabled>--Select--</option>
                    <!-- Group options here -->
                    <option selected disabled>--Select--</option>
                    <option value="0">All Clients</option>
                    @foreach($stations as $group)
                      <option value="{{ $group->node_uuid }}">{{ $group->node_name }}</option>
                    @endforeach
                </select>
            </div>

          
            <!-- Group that will receive the SMS -->
            {{-- <div class="form-group">
              <label for="group">Group</label>
              <select class="form-select" id="group" name="group">
                <option selected disabled>--Select--</option>
                <option value="0">All Clients</option>
                @foreach($stations as $group)
                  <option value="{{ $group->node_uuid }}">{{ $group->node_name }}</option>
                @endforeach
              </select>
            </div> --}}

            <!-- Default sms -->
            <div class="form-group">
              <label for="default-sms">Default Message</label>
              <select class="form-select" id="default-sms" name="default_sms">
                <option selected disabled>--Select--</option>
                @foreach($sms as $key=> $smsMessage)
                  <option data-sms_content="{{ $smsMessage->sms_content }}" value="{{ $smsMessage->id }}">{{ $smsMessage->sms_type }}</option>
                @endforeach
              </select>
            </div>           
            
            <div class="form-group">
              <label for="sms-message">Message</label>
              <textarea class="form-control" id="sms-message" rows="3"></textarea>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="button" id="sendSMSButton" class="btn btn-primary">Send SMS</button>
        </div>
      </div>
    </div>
  </div>

  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">
    
      <div class="container-fluid" style="padding-top: calc(70px + 15px)">
        <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">SMS</h5>
                    </div>
                    
                    <div>
                      <button class="btn btn-primary" data-toggle="modal" data-target="#addSMSModal">Add SMS</button>

                      {{-- <div> --}}
                      <button class="btn btn-primary" data-toggle="modal" data-target="#sendSMSModal">Send SMS</button>
                    {{-- </div> --}}

                      <a href="{{ url('/sms-history') }}" class="btn btn-primary" >SMS History</a>
                    </div>
                
              </div>
            </div>
          </div>

        </div>
        
         <div class="row">
            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <div class="row">
                    <div class="col-md-6">
                      <h5 class="card-title fw-semibold mb-4">SMS</h5>
                    </div>
                    <div class="col-md-6 d-flex justify-content-end">
                      <form id="searchForm" class="mb-3">
                        <div class="input-group">
                          <input type="text" name="search" class="form-control" placeholder="Search SMS" value="{{ request()->get('search') }}">
                          <button  class="btn btn-primary">Search</button>
                        </div>
                      </form>
                    </div>
                  </div>

                  <div class="table-responsive" >
                    <table class="table text-nowrap mb-0 align-middle">
                      <thead class="text-dark fs-4">
                        <tr>
                          <th class="border-bottom-0">
                              <input type="checkbox" id="selectAll">
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Id</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">SMS Type</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Feature</h6>
                          </th>
                         
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">SMS Content</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Action</h6>
                          </th>

                        </tr>
                      </thead>
                      <tbody>
                          @foreach($sms as $key=> $sms)
                        <tr>
                          <td>
                            <input type="checkbox" id="selectAll">
                          </td>
                          <td>
                            <h6 class="mb-0">{{ $key + 1 }}</h6>
                          </td>
                          <td>
                            <h6 class="mb-0">{{ $sms->sms_type }}</h6>
                          </td>
                          <td style="white-space: pre-wrap;">
                            <h6 class="mb-0">{{ $sms_features[$sms->sms_feature] }}</h6>
                          </td>
                          <td style="white-space: pre-wrap;">
                                <h6 class="mb-0">{{ $sms->sms_content }}</h6>
                          </td>

                          <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-0 fs-4">
                                <div class="dropdown">
                                  <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Select Action
                                  </button>
                                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                     <button type="button" class="dropdown-item edit-button" data-toggle="modal" data-target="#editModal" data-id="{{ $sms->id }}">
                                      Edit
                                    </button>

                                     <button type="button" class="dropdown-item remove-button" data-toggle="modal" data-target="#removeModal" data-id="{{ $sms->id }}">
                                      Remove
                                    </button>
                                  </div>
                                </div>
                              </h6>
                            </td>

                        </tr>
                        @endforeach
                        
                      </tbody>
                    </table>
                  </div>
                  <br>
                  <br>
                  <div class="d-flex align-items-center justify-content-end">
                    {{-- <nav aria-label="Page navigation example">
                      <ul class="pagination">
                        <li class="page-item" style="cursor: pointer;"><a class="page-link" onclick="previousPage()">Previous</a></li>
                        <li class="page-item"><a class="page-link" href="#" disabled="true">{{ $page_number }} of {{ $total_pages }} </a></li>
                        <li class="page-item" style="cursor: pointer;"><a class="page-link" onclick="nextPage()">Next</a></li>
                      </ul>
                    </nav>  --}}
                  </div>
                </div>
              </div>
            </div>
          </div> 

      </div>
    </div>

  </div>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> 
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script>
$(document).ready(function() {

  $('#default-sms').change(function(){
        //console.log("Default sms change");
        var smsContent = $('option:selected', this).data('sms_content');
        //console.log(smsContent);
        $('#sms-message').val(smsContent);
  });

  $('#sendSMSButton').on('click', function(e) {
    e.preventDefault();

    var group = $('#group').val();
    var message = $('#sms-message').val();
    var client = $('#client').val();
  
    //get token from the form
    let token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
    
    Swal.fire({
      title: 'Are you sure?',
      text: "You are about to send an SMS to all clients.",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, send it!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          url: `{{ url('/send-sms') }}`,
          type: 'POST',
          data: {
            group: group,
            message: message,
            client: client,
            _token: token
          },
          success: function(response) {
            // Handle success
            //console.log(response);
            Swal.fire("Success!", "The SMS has been sent.", "success").then((result) => {
              if (result.isConfirmed) {
                location.reload();
              }
            });
          },
          error: function(error) {
            // Handle error
            //console.log(error);
            Swal.fire("Error!", "There was an error sending the SMS.", "error");
          }
        });
      }
    });
  });

  //implement the edit sms logic
  $('.edit-button').on('click', function() {
    var id = $(this).data('id');

    $.ajax({
      type: 'GET',
      url: `{{ url('/sms-edit') }}/${id}`,
      success: function(response) {
        $('#editSMSForm input[name="smsType"]').val(response.sms_type);
        $('#editSMSForm textarea[name="content"]').val(response.sms_content);
        $('#editSMSForm').attr('data-id', response.id);
      },
      error: function(response) {
        Swal.fire("Error!", "There was an error fetching the SMS.", "error");
      }
    });
  });

  $('#editSMSForm').on('submit', function(e) {
    e.preventDefault();

    var id = $(this).data('id');
    var formData = $(this).serialize();

    //add token
    formData += '&_token=' + '{{ csrf_token() }}';

    Swal.fire({
      title: 'Are you sure?',
      text: "You are about to update this SMS.",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, update it!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          type: 'POST',
          url: `{{ url('/sms-update') }}/${id}`,
          data: formData,
          success: function(response) {
            Swal.fire("Success!", "The SMS has been updated.", "success").then((result) => {
              if (result.isConfirmed) {
                location.reload();
              }
            });
          },
          error: function(response) {
            Swal.fire("Error!", "There was an error updating the SMS.", "error");
          }
        });
      }
    });
  });

  //implement the remove sms logic
  $('.remove-button').on('click', function() {
    var id = $(this).data('id');

    Swal.fire({
      title: 'Are you sure?',
      text: "You are about to remove this SMS.",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, remove it!'
    }).then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          type: 'GET',
          url: `{{ url('/sms-remove') }}/${id}`,
          success: function(response) {
            Swal.fire("Success!", "The SMS has been removed.", "success").then((result) => {
              if (result.isConfirmed) {
                location.reload();
              }
            });
          },
          error: function(response) {
            Swal.fire("Error!", "There was an error removing the SMS.", "error");
          }
        });
      }
    });
  });

  $('#addSMSForm').on('submit', function(e) {
    e.preventDefault();

      Swal.fire({
            title: 'Are you sure?',
            text: "You are about to add an SMS message.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, add it!'
      }).then((result) => {
      if (result.isConfirmed) {
        var formData = $(this).serialize();

        //add token
        formData += '&_token=' + '{{ csrf_token() }}';

        $.ajax({
          type: 'POST',
          url: `{{ url('/sms-store') }}`,
          data: formData,
          success: function(response) {
            Swal.fire("Success!", "The SMS has been created.", "success").then((result) => {
              if (result.isConfirmed) {
                location.reload();
              }
            })
          },
          error: function(response) {
            Swal.fire("Error!", "There was an error creating the SMS.", "error");
          }
        });
      }
    });
  });
});

 function toggleGroupField() {
        var clientSelect = document.getElementById('client');
        var groupSelect = document.getElementById('group');
        groupSelect.disabled = clientSelect.value !== '';
    }

    function toggleClientField() {
        var clientSelect = document.getElementById('client');
        var groupSelect = document.getElementById('group');
        clientSelect.disabled = groupSelect.value !== '';
    }
</script>


@endsection