{{-- <link rel="stylesheet" href="{{ asset('public/assets/css/tree_table/tree-table.css') }}"> --}}

@extends('layouts.main')

@section('title', 'Nerve Tech Client Management System')

@section('content')  
<style>
    .toggle-btn {
        background: none;
        border: none;
        cursor: pointer;
        outline: none;
    }

    .toggle-icon {
        font-size: 1.2rem;
        color: #3498db; /* Change the color as needed */
        transition: transform 0.3s ease-in-out;
    }

    .toggle-btn[aria-expanded="true"] .toggle-icon {
        transform: rotate(45deg);
    }

    .child-row {
        background-color: #f8f9fa; /* Background color for child rows */
    }
</style>


    <div class="modal fade" id="addNodeModal" tabindex="-1" role="dialog" aria-labelledby="addNodeModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="addNodeModalLabel">Add Node</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <div class="modal-body">
                <form id="addNodeForm">
                    <div class="form-group">
                        <label for="node_name">Node Name</label>
                        <input type="text" class="form-control" id="node_name" name="node_name">
                    </div>

                    <!-- Implement Base Station select option -->
                    <div class="form-group" id="baseStationGroup">
                        <label for="base_station">Base Station</label>
                        <select class="form-select" id="base_station" name="base_station">
                            <option selected disabled>--Select--</option>
                            @foreach ($nodes as $base_station)
                                <option value="{{ $base_station->node_uuid }}">{{ $base_station->node_name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="location">Location</label>
                        <input type="text" class="form-control" id="location" name="location">
                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option selected disabled>--Select--</option>
                            <option value="online">Online</option>
                            <option value="offline">offline</option>
                        </select>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="addNodeSubmit">Submit</button>
                    </div>
                </form>
            </div>
            
        </div>
        </div>
    </div>

<div class="modal fade" id="editNodeModal" tabindex="-1" role="dialog" aria-labelledby="editNodeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editNodeModalLabel">Edit Node</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="editNodeForm">
                    <div class="form-group">
                        <label for="node_name">Node Name</label>
                        <input type="text" class="form-control" id="edit_node_name" name="node_name">
                    </div>

                    {{-- <div class="form-group">
                        <label for="node_type">Node Type</label>
                        <select class="form-control" id="edit_node_type" name="node_type">
                            <option selected disabled>--Select--</option>
                            <option value="primary">Primary</option>
                            <option value="normal">Normal</option>
                        </select>
                    </div> --}}

                    <div class="form-group" id="editBaseStationGroup" style="display: none;">
                        <label for="base_station">Base Station</label>
                        <select class="form-select" id="edit_base_station" name="base_station">
                            <option selected disabled>--Select--</option>
                              @foreach ($nodes as $base_station)
                                  <option value="{{ $base_station->node_uuid }}">{{ $base_station->node_name }}</option>
                              @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="location">Location</label>
                        <input type="text" class="form-control" id="edit_location" name="location">
                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-control" id="edit_status" name="status">
                            <option selected disabled>--Select--</option>
                            <option value="online">Online</option>
                            <option value="offline">Offline</option>
                        </select>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary" id="editNodeSubmit">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="defineMainNodeModal" tabindex="-1" role="dialog" aria-labelledby="defineMainNodeModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="defineMainNodeModalLabel">Define Main Node</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <form id="defineMainNodeForm">
              <div class="form-group  ">
                  <label for="main_base_station">Main Base Station</label>
                  <select class="form-control" id="main_base_station" name="main_base_station">
                    <option selected disabled>--Select--</option>
                    {{-- @foreach ($nodes as $base_station)
                      @if ($base_station->node_type == 'primary')
                        <option value="{{ $base_station->node_uuid }}" {{ $base_station->main_base_station == 'main' ? 'selected' : '' }}>
                          {{ $base_station->node_name }}
                        </option>                      
                      @endif
                    @endforeach --}}
                  </select>
              </div>

              <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="defineMainNodeSubmit">Submit</button>
              </div>
          </form>
      </div>
    </div>
  </div>
</div>

<!--  Body Wrapper -->
<div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">

      <!--  Main wrapper -->
      <div class="" style="padding-top: calc(70px + 15px)">
        
       
        <div class="container-fluid">
          <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">Manage Nodes</h5>
                    </div>
                    <div>

                      <!-- Button trigger modal -->
                      <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addNodeModal">
                        Add Node
                      </button>


                      <button id="deleteSelected" class="btn btn-primary" type="button">Delete Selected</button>

                      </div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12">
                  
                </div>
                <div class="col-lg-12">
                  
                </div>
              </div>
            </div>
          
           
          <div class="row">
            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <div class="row">
                    <div class="col-md-6">
                      <h5 class="card-title fw-semibold mb-4">Nodes</h5>
                    </div>



                  <div class="table-responsive" >
                    <table class="table text-nowrap mb-0 align-middle">
                      <thead class="text-dark fs-4">
                        <tr>
                          <th class="border-bottom-0">
                              <input type="checkbox" id="selectAll">
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Id</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Node Name</h6>
                          </th>
          
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Location</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Status</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Action</h6>
                          </th>

                        </tr>
                      </thead>

                        <tbody>
                            @php
                                function renderNodes($stations, $parentKey = '') {
                                    foreach ($stations as $key => $station) {
                                        $currentKey = $parentKey . ($key + 1);

                                        echo '<tr class="node-row">';
                                        echo '<td>';

                                        if ($station->children && $station->children->isNotEmpty()) {
                                            echo '<button class="toggle-btn" data-target="#children' . $station->id . '" aria-expanded="false">';
                                            echo '<span class="toggle-icon">-</span>';
                                            echo '</button>';
                                        }

                                        echo '</td>';

                                        echo '<td>' . $currentKey . '</td>';

                                        echo '<td>' . $station->node_name . '</td>';
                                        echo '<td>' . $station->location . '</td>';
                                        echo '<td>' . $station->status . '</td>';
                                        echo '<td>';
                                        //drop dropdown button
                                        echo '<div class="dropdown">';
                                        echo '<button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">';
                                        echo 'Action';
                                        echo '</button>';
                                        echo '<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">';
                                        echo '<a class="dropdown-item edit-node" href="#" data-id="' . $station->id . '" data-toggle="modal" data-target="#editNodeModal">Edit</a>';
                                        echo '<a class="dropdown-item delete-node" href="#" data-id="' . $station->id . '">Delete</a>';
                                        echo '</div>';
                                        echo '</div>';
                                        echo '</td>';
                                        echo '</tr>';

                                        if ($station->children && $station->children->isNotEmpty()) {
                                            echo '<tr class="child-row" id="children' . $station->id . '" >';
                                            echo '<td colspan="6">';
                                            echo '<table class="table">';
                                            echo '<tbody>';
                                            renderNodes($station->children, $currentKey . '.');
                                            echo '</tbody>';
                                            echo '</table>';
                                            echo '</td>';
                                            echo '</tr>';
                                        }
                                    }
                                }
                                renderNodes($stations);
                            @endphp
                        </tbody>
                    </table>
                  </div>
                  <br>
                  <br>
                </div>
              </div>
            </div>
          </div>    
        </div>    
      </div>
    </div>
@endsection

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<script src="{{ asset('public/assets/js/tree_table/tree-table.js') }}"></script>
<script>
  $(document).ready(function () {
    $('.toggle-btn').click(function () {
      var target = $($(this).data('target'));
      target.toggle();
      var icon = $(this).find('.toggle-icon');
      icon.text(target.is(':visible') ? '-' : '+');
    });
  });
</script>

<script>
    $(document).ready(function() {

      let nodeId = '';

        //implement add node with sweet alert asking user to add node
        $('#addNodeForm').on('submit', function(e) {
            e.preventDefault();
            const node_name = $('#node_name').val();
            const location = $('#location').val();
            const status = $('#status').val();
            const node_type = $('#node_type').val();
            const base_station = $('#base_station').val();
            const main_base_station = $('#main_base_station').val();
            if(node_name == '' || location == '' || status == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'All fields are required!',
                });
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to add this node",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, add it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `{{ url('/add-node') }}`,
                            type: 'POST',
                            data: {
                                node_name: node_name,
                                location: location,
                                node_type: node_type,
                                base_station: base_station,
                                status: status,
                                _token: `{{ csrf_token() }}`
                            },
                            success: function(response) {
                                if(response) {
                                    Swal.fire(
                                        'Added!',
                                        'Node has been added.',
                                        'success'
                                    ).then(() => {
                                        window.location.reload();
                                    });
                                }
                            },
                            error: function(response) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: response.responseJSON.message,
                                });
                            }
                        });
                    }
                });
            }
        });

        //implement define main node
        $('#defineMainNodeForm').on('submit', function(e) {
            e.preventDefault();
            const main_base_station = $('#main_base_station').val();
            if(main_base_station == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'All fields are required!',
                });
            } else {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to define this node as main node",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, define it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `{{ url('/define-main-node') }}`,
                            type: 'POST',
                            data: {
                                main_base_station: main_base_station,
                                _token: `{{ csrf_token() }}`
                            },
                            success: function(response) {
                                if(response) {
                                    Swal.fire(
                                        'Defined!',
                                        'Node has been defined as main node.',
                                        'success'
                                    ).then(() => {
                                        window.location.reload();
                                    });
                                }
                            },
                            error: function(response) {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Oops...',
                                    text: response.responseJSON.message,
                                });
                            }
                        });
                    }
                });
            }
        });

        //implement edit node
        $(document).on('click', '.edit-node', function(e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            nodeId = id;
            $.ajax({
                url: `{{ url('/edit-node') }}`,
                type: 'GET',
                data: {
                    id: id
                },
                success: function(response) {
                    $('#edit_node_name').val(response.node_name);
                    $('#edit_location').val(response.location);
                    $('#edit_status').val(response.status);

                    //if response.node_type is primary select the option with value primary

                    if(response.node_type === 'primary') {
                      $('#edit_node_type').val('primary');
                    } else {
                      $('#edit_node_type').val('normal');
                      $('#editBaseStationGroup').show();
                      $('#edit_base_station').val(response.base_station);                    
                    }
                },
                error: function(response){
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: response.responseJSON.message,
                    });
                }
            });
        });

        $('#editNodeForm').on('submit', function(e) {
            e.preventDefault();
            var node_name = $('#edit_node_name').val();
            var location = $('#edit_location').val();
            var status = $('#edit_status').val();
            var node_type = $('#edit_node_type').val();
            var base_station = $('#edit_base_station').val();


            if(node_name == '' || location == '' || status == '') {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'All fields are required!',
                });
            } else {


                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to edit this node",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, edit it!'
                }).then((result) => {

                    if (result.isConfirmed) {

                        $.ajax({
                            url: `{{ url('/update-node') }}`,
                            type: 'POST',
                            data: {
                                id: nodeId,
                                node_name: node_name,
                                location: location,
                                node_type: node_type,
                                base_station: base_station,
                                status: status,
                                _token: `{{ csrf_token() }}`
                            },
                            success: function(response) {
                                if(response) {
                                    Swal.fire(
                                        'Updated!',
                                        'Node has been updated.',
                                        'success'
                                    ).then((isConfirmed) => {
                                        if(isConfirmed){
                                            window.location.reload();
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });

        
        //implement delete node
        $(document).on('click', '.delete-node', function(e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this node",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: `{{ url('/delete-node') }}`,
                        type: 'POST',
                        data: {
                            id: id,
                            _token: `{{ csrf_token() }}`
                        },
                        success: function(response) {
                            if(response) {
                                //fetchNodes(page_number, search);
                                Swal.fire(
                                    'Deleted!',
                                    'Node has been deleted.',
                                    'success'
                                ).then(() => {
                                    location.reload();
                                });
                            }
                        }
                    });
                }
            });
        });

        //$('#node_type').change(function() {
            //if ($(this).val() === 'normal') {
                //$('#baseStationGroup').show();

            //} else {
                //$('#baseStationGroup').hide();
            //}
        //});

        //$('#edit_node_type').change(function() {
            //var nodeType = $(this).val();

            //if (nodeType === 'primary') {
                //$('#editBaseStationGroup').hide();
            //} else if (nodeType === 'normal') {
                //$('#editBaseStationGroup').show();
            //}
        //});
    });
</script>
