<?php
use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'AuthenticationController@login');

Route::post('/login','AuthenticationController@loginPost');

Route::get('/clients/{page_number}', 'ClientManagerController@client');

Route::post('/add-client', 'ClientManagerController@addClient')->name('add-client');

Route::post('/renew-client', 'ClientManagerController@renewClient');

Route::get('/clients/{id}/receiptsById','ClientManagerController@receiptsById');

Route::get('/clients/{id}/edit', 'ClientManagerController@edit');

Route::post('/clients', 'ClientManagerController@update');

Route::delete('/clients/{id}', 'ClientManagerController@delete');

Route::delete('/delete-clients','ClientManagerController@deleteClients');

Route::get('/packages/{page_number}','PackageController@index');

Route::post('/add-package', 'PackageController@addPackage')->name('add-package');

Route::get('/packages/{id}/edit', 'PackageController@edit');

Route::post('/packages/{id}', 'PackageController@update');

Route::delete('/packages/{id}', 'PackageController@delete');

Route::delete('/delete-packages','PackageController@deletePackages');

Route::post('/import-clients', 'ClientManagerController@importClients');

Route::get('/support-ticket','SupportTicketController@index');

Route::get('/finance/{page_number}','FinanceController@index');

Route::get('/dashboard','DashboardController@index');

Route::get('/settings','DashboardController@settings');

Route::get('/default-renewal','ClientManagerController@defaultRenewal');

Route::post('/admin-info-update','DashboardController@adminInfoUpdate');

Route::post('/search-client','ClientManagerController@searchClients');

//Search SMS history
Route::post('/search-sms-history','SMSController@searchSmsHistory');

//search finance
Route::post('/search-finance','FinanceController@searchFinance');

//search plans
Route::post('/search-plans','PackageController@searchPlans');

Route::get('/sms','SMSController@index');

Route::get('/crontest','ClientManagerController@crontest');

Route::post('/sms-store','SMSController@smsStore');

Route::get('/sms-edit/{id}','SMSController@smsEdit');

Route::post('/sms-update/{id}','SMSController@smsUpdate');

Route::get('/sms-remove/{id}','SMSController@smsRemove');

Route::post('/send-sms','SMSController@smsSendToAllClient');

Route::post('/send-sms-to-client','SMSController@smsSendToClient');

Route::get('/station','StationController@index');

Route::post('/add-node','StationController@addNode');

Route::post('/delete-node','StationController@deleteNode');

Route::get('/edit-node','StationController@editNode');

Route::post('/update-node','StationController@updateNode');

Route::post('/define-main-node','StationController@defineMainNode');

Route::post('/make-payment','PaymentController@makePayment');

//client-wallet
Route::post('/client-wallet','ClientManagerController@clientWallet');

Route::get('/subs-auto-renewal','ClientManagerController@subscription_auto_renewal');

//sms-history
Route::get('/sms-history','SMSController@smsHistory');

//financial-summary
Route::get('/financial-summary','FinanceController@financialSummary');

//financial-summary post
Route::post('/financial-summary','FinanceController@financialSummaryPost');




