
<?php $__env->startSection('content'); ?>
<section>
    <div class="p-5">
        <div class="row">
            <div class="col-6">
                <div class="card flex-fill">
                    <div class="card-header">
                        <h3 class="">Transcript Details</h3><br>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <tbody>
                                <tr>
                                    <td><b>Tracking No: </b></td>
                                    <td class="text-truncate"> <?php echo e($ordered_document['tracking_no']); ?> </td>
                                </tr>
                                <tr>
                                    <td><b>Index No: </b></td>
                                    <td> <?php echo e($ordered_document['index_no']); ?></td>
                                </tr>
                                <tr>
                                    <td><b>Applicant Name: </b></td>
                                    <td> <?php echo e($ordered_document['applicant_name']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Email Address: </b></td>
                                    <td> <?php echo e($ordered_document['emailaddress']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Year of Admission: </b></td>
                                    <td> <?php echo e($ordered_document['year_of_admission']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Year of Completion: </b></td>
                                    <td> <?php echo e($ordered_document['year_of_completion']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Program: </b></td>
                                    <td> <?php echo e($ordered_document['program']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Type of Document: </b></td>
                                    <td> <?php echo e($ordered_document['type_of_document']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Delivery Mode: </b></td>
                                    <td> <?php echo e($ordered_document['delivery_mode']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Postal Address: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['postal_address']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Country: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['country']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Zip Code: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['zip_code']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>State: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['state']); ?> </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td><b>Document Status: </b></td>
                                    <td>
                                        <span class="badge bg-warning"> <?php echo e($ordered_document['status']); ?> </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>



                        <div class="d-flex align-items-center justify-content-end">
                            <div class="dropdown" style="margin-right: 10px;">
                                <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Change Document Status
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <button class="dropdown-item" onclick="toggleDocumentStatus('Just Applied')">Just Applied</button>
                                    <button class="dropdown-item" onclick="toggleDocumentStatus('Printed')">Printed</button>
                                    <button class="dropdown-item" onclick="toggleDocumentStatus('Signed')">Signed</button>
                                    <button class="dropdown-item" onclick="toggleDocumentStatus('Posted')">Posted</button>
                                </div>
                            </div>
                            <button class="btn btn-danger text-white" onclick="deleteDocument()"><i class="align-middle ml-1" data-feather="trash"></i>Delete</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6"></div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<script>
function toggleDocumentStatus(status) {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let ordered_document = <?php echo json_encode($ordered_document); ?>;
    let body = {
        tracking_no: ordered_document['tracking_no'],
        status: status,
        _token: csrfToken
    }

    Swal.fire({
        title: 'Info',
        text: 'Do you want to save privillages?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33',

    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/toggle-document-status')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'Document status has been toggled successfully!' :
                            'Document status could not be toggled!',
                        icon: result_,
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    }).then((result) => {
                        window.location.reload();
                    })
                }
            });

        }
    });
}

function deleteDocument() {
    var ordered_document = <?php echo json_encode($ordered_document); ?>;
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
        let body = {
            tracking_no: ordered_document['tracking_no'],
            _token: csrfToken
        }

        Swal.fire({
            title: 'Info',
            text: 'Do you want to to delete?',
            icon: 'question',
            confirmButtonText: 'Yes',
            showCancelButton: true,
            cancelButtonText: 'No',
            confirmButtonColor: '#1cc88a',
            cancelButtonColor: '#d33',

        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `<?php echo e(url('/delete-document')); ?>`,
                    method: 'POST',
                    data: body,
                    success: function(result_) {
                        Swal.fire({
                            title: 'Info',
                            text: result_ == 'success' ?
                                'Document has been deleted successfully!!' :
                                'Document could not be deleted!',
                            icon: result_,
                            confirmButtonText: 'Okay',
                            confirmButtonColor: '#1cc88a'

                        }).then((result) => {
                            history.back();
                        })
                    }
                });

            }
        });
}

</script>
<?php echo $__env->make('master_view', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>