<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.datatables.buttons.min.css')); ?>">

<?php $__env->startSection('content'); ?>
<section>
    <div class="p-5">
        <div class="row">
            <div class="col-6">
                <div class="card flex-fill">
                    <div class="card-header">
                        <h3 class="">Transcript Details</h3><br>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <tbody>
                                <tr>
                                    <td><b>Tracking No: </b></td>
                                    <td class="text-truncate"> <?php echo e($ordered_document['tracking_no']); ?> </td>
                                </tr>
                                <tr>
                                    <td><b>Index No: </b></td>
                                    <td> <?php echo e($ordered_document['index_no']); ?></td>
                                </tr>
                                <tr>
                                    <td><b>Applicant Name: </b></td>
                                    <td> <?php echo e($ordered_document['applicant_name']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Email Address: </b></td>
                                    <td> <?php echo e($ordered_document['emailaddress']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Contact: </b></td>
                                    <td> <?php echo e($ordered_document['phone_no']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Year of Admission: </b></td>
                                    <td> <?php echo e($ordered_document['year_of_admission']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Year of Completion: </b></td>
                                    <td> <?php echo e($ordered_document['year_of_completion']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Program: </b></td>
                                    <td> <?php echo e($ordered_document['program']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Type of Document: </b></td>
                                    <td> <?php echo e($ordered_document['type_of_document']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Delivery Mode: </b></td>
                                    <td> <?php echo e($ordered_document['delivery_mode']); ?> </td>
                                </tr>

                                <tr>
                                    <td><b>Postal Address: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['postal_address']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Country: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['country']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>Zip Code: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['zip_code']); ?> </div>
                                    </td>
                                </tr>

                                <tr>
                                    <td><b>State: </b></td>
                                    <td>
                                        <div> <?php echo e($ordered_document['state']); ?> </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td><b>Document Status: </b></td>
                                    <td>
                                        <span class="badge bg-warning"> <?php echo e($ordered_document['status']); ?> </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>



                        <div class="d-flex align-items-center justify-content-end">
                            <button class="btn btn-secondary text-white me-2" onclick="uploadFile()"><i
                                    class="fas fa-file-upload me-1"></i>Upload File</button>
                            <button class="btn btn-primary text-white me-2" onclick="previewFile()"><i
                                    class="fas fa-file me-1"></i>Preview File</button>
                            <div class="dropdown" style="margin-right: 10px;">
                                <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Change Document Status
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <button class="dropdown-item" onclick="toggleDocumentStatus('Just Applied')">Just
                                        Applied</button>
                                    <button class="dropdown-item"
                                        onclick="toggleDocumentStatus('Printed')">Printed</button>
                                    <button class="dropdown-item"
                                        onclick="toggleDocumentStatus('Signed')">Signed</button>
                                    <button class="dropdown-item"
                                        onclick="toggleDocumentStatus('Posted')">Posted</button>
                                </div>
                            </div>
                            <button class="btn btn-danger text-white" onclick="deleteDocument()"><i
                                    class="align-middle ml-1" data-feather="trash"></i>Delete</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-6"></div>
        </div>
    </div>

    <div class="modal fade" id="upload-document" tabindex="-1" role="dialog" aria-labelledby="addDesignationModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addDesignationModalLabel">Select Document To Upload</h5>

                    <button type="button" class="btn btn-sm bg-danger text-white" onclick="dismissUploadModal()"
                        class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true" style="color: white;">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="uploadForm" enctype="multipart/form-data">
                        <input type="file" accept="application/pdf" name="pdfFile" id="pdfFile">
                        <button type="button" onclick="uploadPdfFile(event)">Upload PDF</button>
                    </form>
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0"
                            aria-valuemax="100"></div>
                    </div>
                    <div id="message"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="preview-document" tabindex="-1" role="dialog" aria-labelledby="previewUploadFileLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewUploadFileLabel">Preview File</h5>

                    <button type="button" class="btn btn-sm bg-danger text-white" onclick="dismissPreviewModal()"
                        class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true" style="color: white;">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="previewPdfContainer">

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/pdf/pdf.js')); ?>"></script>
<script>
function uploadPdfFile(e) {
    e.preventDefault();
    let ordered_document = <?php echo json_encode($ordered_document); ?>;
    const fileInput = document.getElementById('pdfFile');

    const file = fileInput.files[0];
    if (file) {
        var formData = new FormData();

        formData.append('file', file);
        formData.append('tracking_no', ordered_document['tracking_no']);
        console.log(formData);
        $.ajax({
            url: '<?php echo e(url("upload-pdf")); ?>',
            method: 'post',
            data: formData,
            contentType: false,
            processData: false,
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            xhr: function() {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(evt) {
                    if (evt.lengthComputable) {
                        var percentComplete = evt.loaded / evt.total * 100;
                        percentComplete = Number(percentComplete).toFixed(2);
                        $('.progress-bar').width(percentComplete + '%');
                        $('.progress-bar').html(percentComplete + '%');
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                $('.progress-bar').width('0%');
                $('.progress-bar').html('0%');
                $('#message').html('File uploaded successfully');
                if (response == 'success') {
                    $('#upload-document').modal('hide');
                    Swal.fire({
                        title: 'Info',
                        text: 'Document has been uploaded successfully!',
                        icon: 'success',
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'
                    });
                } else {
                    Swal.fire({
                        title: 'Info',
                        text: 'Document could not be uploaded',
                        icon: 'error',
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'
                    });
                }
            },
            error: function(xhr, status, error) {
                $('.progress-bar').width('0%');
                $('.progress-bar').html('0%');
                $('#message').html('Error uploading file: ' + error);
            }
        });
    } else {
        console.log('File has been uploaded successfully!');
    }
}

function printDiv(divName) {
    var printContents = document.getElementById(divName).innerHTML;
    var originalContents = document.body.innerHTML;

    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;
}

function toggleDocumentStatus(status) {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let ordered_document = <?php echo json_encode($ordered_document); ?>;
    let body = {
        tracking_no: ordered_document['tracking_no'],
        status: status,
        _token: csrfToken
    }

    Swal.fire({
        title: 'Info',
        text: 'Do you want to save privillages?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33',

    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/toggle-document-status')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'Document status has been toggled successfully!' :
                            'Document status could not be toggled!',
                        icon: result_,
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    }).then((result) => {
                        window.location.reload();
                    })
                }
            });

        }
    });
}


function deleteDocument() {
    var ordered_document = <?php echo json_encode($ordered_document); ?>;
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let body = {
        tracking_no: ordered_document['tracking_no'],
        _token: csrfToken
    }

    Swal.fire({
        title: 'Info',
        text: 'Do you want to to delete?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33',

    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/delete-document')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'Document has been deleted successfully!!' :
                            'Document could not be deleted!',
                        icon: result_,
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    }).then((result) => {
                        history.back();
                    })
                }
            });

        }
    });
}

function dismissUploadModal() {
    $('#upload-document').modal('hide');
}

function uploadFile() {
    $('#upload-document').modal('show');
}

function previewFile() {
    let ordered_document = <?php echo json_encode($ordered_document); ?>;
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let formData = {
        tracking_no: ordered_document['tracking_no'],
        _token: csrfToken
    }

    $.ajax({
        url: `<?php echo e(url('/preview-uploaded-document')); ?>`,
        type: 'POST',
        data: formData,
        success: function(data) {
            if (data == "failed") {
                Swal.fire({
                    title: 'Info',
                    text: 'No document have been uploaded yet!',
                    icon: 'error',
                    confirmButtonText: 'Okay',
                    confirmButtonColor: '#1cc88a'

                })
                return;
            }

            previewPdf(`<?php echo e(url('${data}')); ?>`);
        },
        error: function(xhr, status, error) {
            console.log('Error uploading file: ' + error);
        }
    });
}

function previewPdf(pdfUrl) {
    var pdfId = document.getElementById("previewPdfContainer");
    pdfId.removeChild(pdfId.childNodes[0]);
    var embed = document.createElement('embed');
    embed.style.width = "100%";
    embed.style.height = "700px";
    embed.setAttribute('src', pdfUrl);
    embed.setAttribute('type', 'application/pdf');
    pdfId.appendChild(embed);
    $('#preview-document').modal('show');
}

function dismissPreviewModal() {
    $('#preview-document').modal('hide');
}
</script>
<?php echo $__env->make('master_view', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>