<nav class="navbar navbar-expand navbar-light navbar-bg">
    <a class="sidebar-toggle js-sidebar-toggle">
        <i class="hamburger align-self-center"></i>
    </a>

    <div class="navbar-collapse collapse">
        <ul class="navbar-nav navbar-align">
            <li class="nav-item dropdown">
                <a class="nav-icon dropdown-toggle d-inline-block d-sm-none" href="#" data-bs-toggle="dropdown">
                    <i class="align-middle" data-feather="settings"></i>
                </a>

                <a class="nav-link dropdown-toggle d-none d-sm-inline-block" href="#" data-bs-toggle="dropdown">
                    <!-- <img src="<?php echo e(asset('public/assets/img/avatars/avatar.jpg')); ?> "
                        class="avatar img-fluid rounded me-1" alt="Charles Hall" /> -->
                        <i class="align-middle me-1" data-feather="user" style="font-size: 40px;"></i>
                    <span class="text-dark" style="font-size: 18px;"><?php echo Session::get('current_user.name'); ?></span>
                </a>
                <div class="dropdown-menu dropdown-menu-end">
                    <!-- <a class="dropdown-item" href="#"><i class="align-middle me-1" data-feather="user"></i> Profile</a> -->
                    <button class="dropdown-item" onclick="changePassword()"><i class="align-middle me-1" data-feather="key"></i> Change
                        Password</button>
                    <button class="dropdown-item" onclick="logOut()"><i class="align-middle me-1" data-feather="log-out"></i>Log Out</button>
                </div>
            </li>
        </ul>
    </div>


</nav>


<div class="modal fade" id="change_password_modal" tabindex="-1" role="dialog"
    aria-labelledby="changePasswordModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="changePasswordModal">Change Password</h5>

                <button type="button" class="btn btn-sm bg-danger text-white" class="close" data-dismiss="modal"
                    aria-label="Close" onclick="closeModal()">
                    <span aria-hidden="true" style="color: white;">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="old_password">Old Password</label>
                        <input type="password" class="form-control" id="old_password" name="old_password" />
                    </div>
                </div>

                <div class="col-6">
                    <div class="form-group">
                        <label for="new_password">New Password</label>
                        <input type="password" class="form-control" id="new_password" name="new_password" />
                    </div>
                </div>

                </div>
                
                <div class="d-flex align-items-center justify-content-end mt-3">
                    <button class="btn btn-sm bg-primary text-white"  onclick="changePassword_()"><i
                            class="fas fa-key mr-1"></i>Change Password</button>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>

<script>
function logOut() {
    Swal.fire({
        title: 'Info',
        text: 'Do you want to submit?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/log-out')); ?>`,
                method: 'GET',
                success: function(result_) {
                    window.location = `<?php echo e(url('/admin-login')); ?>`;
                }
            });
        }
    });
}


function closeModal() {
    $('#change_password_modal').modal('hide');
}

function changePassword() {
    document.getElementById('old_password').value = "";
    document.getElementById('new_password').value = "";
    $('#change_password_modal').modal('show');
}

function changePassword_() {
    let old_password = document.getElementById('old_password').value;
    let new_password = document.getElementById('new_password').value;
    
    if (old_password == "") {
        return;
    }
    
    if (new_password == "") {
        return;
    }
    
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let body = {
        old_password: old_password,
        new_password: new_password,
        _token: csrfToken
    }

    $.ajax({
        url: `<?php echo e(url('/change-password')); ?>`,
        method: 'POST',
        data: body,
        success: function(result_) {
            console.log(result_);
            result_ = JSON.parse(result_);
            Swal.fire({
                title: 'Info',
                text: result_['msg'],
                icon: result_['status'],
                confirmButtonText: 'Okay',
                confirmButtonColor: '#1cc88a'

            }).then((result) => {
                console.log(result_);
                if (result_['status'] == 'success') {
                    document.getElementById('old_password').value = "";
                    document.getElementById('new_password').value = "";
                    $('#change_password_modal').modal('hide');
                }
            })
        }
    });
}
</script>