<?php $__env->startSection('title', 'Nerve Tech Client Management System'); ?>

<?php $__env->startSection('content'); ?>  

  <div class="modal fade" id="addClientModal" tabindex="-1" role="dialog" aria-labelledby="addClientModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addClientModalLabel">Add Client</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <form id="addClientForm">
            
            
            <div class="form-group">
              <label for="accountUsername">Name</label>
              <input type="text" class="form-control" id="accountUsername" name="accountUsername">
            </div>

            <div class="form-group">
              <label for="username">Username</label>
              <input type="text" class="form-control" id="username" name="username">
            </div>

            <div class="form-group">
              <label for="clientId">Client Id</label>
              <input type="text" class="form-control" id="clientId" name="clientId">
            </div>
            
            <div class="form-group">
              <label for="phoneNumber">Phone Number</label>
              <input type="text" class="form-control" id="phoneNumber" name="phoneNumber">
            </div>
            <!-- Add more form fields here -->
            <div class="form-group">
              <label for="email">Email Address</label>
              <input type="email" class="form-control" id="email" name="email">
            </div>
            <div class="form-group">
              <label for="gps">GPS (Ghana Post Number)</label>
              <input type="text" class="form-control" id="gps" name="gps">
            </div>
            
            <div class="form-group">
                <label for="plan">Plan (Internet Package)</label>
                <select class="form-control" id="plan" name="plan">
                    <option selected disabled> -- Select -- </option>
                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->data_package); ?>(GHC<?php echo e($plan->price); ?>)</option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group">
              <label for="node">Node</label>
              <input type="text" class="form-control" id="node" name="node">
            </div>

            <div class="form-group">
              <label for="expiryDate">Expiry Date</label>
              <input type="date" class="form-control" id="expiryDate" name="expiryDate">
            </div>

            <div class="form-group">
              <label for="referalBonus">Referal Bonus</label>
              <input type="text" class="form-control" id="referalBonus" name="referalBonus">
            </div>

            <div class="form-group">
              <label for="installationType">Installation Type</label>
              <input type="text" class="form-control" id="installationType" name="installationType">
            </div>

            <div class="form-group">
              <label for="status">Status</label>
              <select class="form-control" id="status" name="status">
                  <option selected disabled>--Select--</option>
                  <option value="Active">Active</option>
                  <option value="Expired">Expired</option>
              </select>
            </div>

            <div class="form-group">
              <label for="cpeOutdoor">CPE-OUTDOOR</label>
              <input type="text" class="form-control" id="cpeOutdoor" name="cpeOutdoor">
            </div>

            <div class="form-group">
              <label for="cpeIndoor">CPE-INDOOR</label>
              <input type="text" class="form-control" id="cpeIndoor" name="cpeIndoor">
            </div>
            <!-- <button type="submit" class="btn btn-primary">Submit</button> -->

            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary" id="addClientSubmit">Submit</button>
            </div>
          </form>
        </div>
        
      </div>
    </div>
  </div>

  <!-- Add this outside your table -->
  <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editModalLabel">Edit Client</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="" id="editForm">
                    
                    

                    <div class="form-group">
                        <label for="edit-accountUsername">Name</label>
                        <input type="text" class="form-control" id="edit-accountUsername" name="accountUsername">
                    </div>

                    <div class="form-group">
                        <label for="edit-username">Username</label>
                        <input type="text" class="form-control" id="edit-username" name="username">
                    </div>

                    <div class="form-group">
                        <label for="edit-clientId">Client Id</label>
                        <input type="text" class="form-control" id="edit-clientId" name="clientId">
                    </div>
                    
                    <div class="form-group">
                        <label for="edit-phoneNumber">Phone Number</label>
                        <input type="text" class="form-control" id="edit-phoneNumber" name="phoneNumber">
                    </div>
                    <div class="form-group">
                        <label for="edit-email">Email Address</label>
                        <input type="email" class="form-control" id="edit-email" name="email">
                    </div>
                    <div class="form-group">
                        <label for="edit-gps">GPS (Ghana Post Number)</label>
                        <input type="text" class="form-control" id="edit-gps" name="gps">
                    </div>
                    <div class="form-group">
                        <label for="edit-plan">Plan (Internet Package)</label>
                        <select class="form-control" id="edit-plan" name="plan">
                            <option selected disabled> -- Select -- </option>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->data_package); ?>(GHC<?php echo e($plan->price); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="edit-node">Node</label>
                        <input type="text" class="form-control" id="edit-node" name="node">
                    </div>
                    <div class="form-group">
                        <label for="edit-expiryDate">Expiry Date</label>
                        <input type="date" class="form-control" id="edit-expiryDate" name="expiryDate">
                    </div>
                    <div class="form-group">
                        <label for="edit-referalBonus">Referal Bonus</label>
                        <input type="text" class="form-control" id="edit-referalBonus" name="referalBonus">
                    </div>

                    <div class="form-group">
                        <label for="edit-installationType">Installation Type</label>
                        <input type="text" class="form-control" id="edit-installationType" name="installationType">
                    </div>

                    

                    <div class="form-group">
                      <label for="edit-status">Status</label>
                      <select class="form-control" id="edit-status" name="status">
                          <option selected disabled>--Select--</option>
                          <option value="Active">Active</option>
                          <option value="Expired">Expired</option>
                      </select>
                    </div>

                    <div class="form-group">
                        <label for="edit-cpeOutdoor">CPE OUTDOOR</label>
                        <input type="text" class="form-control" id="edit-cpeOutdoor" name="cpeOutdoor">
                    </div>

                     <div class="form-group">
                        <label for="edit-cpeIndoor">CPE INDOOR</label>
                        <input type="text" class="form-control" id="edit-cpeIndoor" name="cpeIndoor">
                    </div>
                    

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
  </div>

  <div class="modal fade" id="renewModal" tabindex="-1" role="dialog" aria-labelledby="renewModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="renewModalLabel">Renew Client</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="POST" action="" id="renewForm">
              
              

                <div class="form-group">
                      <label for="renew-package">Plan (Internet Package)</label>
                      <select class="form-control" id="renew-package" name="package">
                          <option selected disabled> -- Select -- </option>
                          <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->data_package); ?>(GHC<?php echo e($plan->price); ?>)</option>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                  </div>

              <div class="form-group">
                <label for="renew-date">Renew Date</label>
                <input type="date" class="form-control" id="renew-date" name="renewDate">
              </div>
              <div class="form-group">
                <label for="renew-expiry">Expiry Date</label>
                <input type="date" class="form-control" id="renew-expiry" name="expiryDate">
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary" id="renewClientSubmit">Submit</button>
              </div>
            </form>
          </div>
        </div>
      </div>
  </div>

  <div class="modal fade" id="receiptsModal" tabindex="-1" role="dialog" aria-labelledby="receiptsModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <h5 class="modal-title" id="receiptsModalLabel">Receipts</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                      <span aria-hidden="true">&times;</span>
                  </button>
              </div>
                  <div class="modal-body">
                      
                      <table class="table">
                          <thead>
                              <tr>
                                  <th>Receipt Date</th>
                                  <th>Plan (Internet Package)</th>
                                  <th>Expiry Date</th>
                                  <th>Action</th>
                              </tr>
                          </thead>
                          <tbody id="receiptsTableBody">
                              
                          </tbody>
                      </table>

                      
                  </div>

          </div>
      </div>
  </div>

  <div class="modal fade" id="viewClientModal" tabindex="-1" role="dialog" aria-labelledby="viewClientModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewClientModalLabel">Client Details</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Display client details here -->

                 
                
                
                
                <div class="form-group">
                  <label for="accountUsername">Name</label>
                  <input type="text" class="form-control" id="view-accountUsername" name="accountUsername" disabled>
                </div>

                <div class="form-group">
                  <label for="username">Username</label>
                  <input type="text" class="form-control" id="view-username" name="username" disabled>
                </div>

                <div class="form-group">
                  <label for="clientId">Client ID</label>
                  <input type="text" class="form-control" id="view-clientId" name="clientId" disabled>
                </div>
                
                <div class="form-group">
                  <label for="phoneNumber">Phone Number</label>
                  <input type="text" class="form-control" id="view-phoneNumber" name="phoneNumber" disabled>
                </div>
                <!-- Add more form fields here -->
                <div class="form-group">
                  <label for="email">Email Address</label>
                  <input type="email" class="form-control" id="view-email" name="email" disabled>
                </div>
                <div class="form-group">
                  <label for="gps">GPS (Ghana Post Number)</label>
                  <input type="text" class="form-control" id="view-gps" name="gps" disabled>
                </div>
                
                <div class="form-group">
                    <label for="plan">Plan (Internet Package)</label>
                    <select class="form-control" id="view-plan" name="plan" disabled>
                        <option selected disabled> -- Select -- </option>
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->data_package); ?>(GHC<?php echo e($plan->price); ?>)</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="form-group">
                  <label for="node">Node</label>
                  <input type="text" class="form-control" id="view-node" name="node" disabled>
                </div>

                <div class="form-group">
                  <label for="expiryDate">Expiry Date</label>
                  <input type="date" class="form-control" id="view-expiryDate" name="expiryDate" disabled>
                </div>

                <div class="form-group">
                  <label for="referalBonus">Referal Bonus</label>
                  <input type="text" class="form-control" id="view-referalBonus" name="referalBonus" disabled>
                </div>

                <div class="form-group">
                  <label for="installationType">Installation Type</label>
                  <input type="text" class="form-control" id="view-installationType" name="installationType" disabled>
                </div>

                 <div class="form-group">
                  <label for="status">Status</label>
                  <input type="text" class="form-control" id="view-status" name="status" disabled>
                </div>

                 <div class="form-group">
                  <label for="cpeOutdoor">CPE OUTDOOR</label>
                  <input type="text" class="form-control" id="view-cpeOutdoor" name="cpeOutdoor" disabled>
                </div>

                 <div class="form-group">
                  <label for="cpeIndoor">CPE INDOOR</label>
                  <input type="text" class="form-control" id="view-cpeIndoor" name="cpeIndoor" disabled>
                </div>
               
              
            </div>
            
        </div>
    </div>
  </div>

   <!--  Body Wrapper -->
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">

      <!-- Sidebar Start -->
      <!--  Sidebar End -->
      <!--  Main wrapper -->
      <div class="" style="padding-top: calc(70px + 15px)">
        
        <!--  Header Start -->
        <!--  Header End -->    
        <div class="container-fluid">
          <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">Manage Client</h5>
                    </div>
                    <div>

                      <!-- Button trigger modal -->
                      <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addClientModal">
                        Add Client
                      </button>

                      <input type="file" id="excelFile" accept=".csv" style="display: none;" />
                      <a class="btn btn-primary" onclick="uploadFile();">Import Client</a>

                      <button id="deleteSelected" class="btn btn-primary" type="button">Delete Selected</button>

                      </div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12">
                  
                </div>
                <div class="col-lg-12">
                  
                </div>
              </div>
            </div>
          </div>
           
          <div class="row">
            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <h5 class="card-title fw-semibold mb-4">Clients</h5>
                  <div class="table-responsive">
                    <table class="table text-nowrap mb-0 align-middle">
                      <thead class="text-dark fs-4">
                        <tr>
                          <th class="border-bottom-0">
                              <input type="checkbox" id="selectAll">
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Id</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Name</h6>
                          </th>
                          
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Expiry Date</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Status</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Action</h6>
                          </th>

                        </tr>
                      </thead>
                      <tbody>
                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td class="border-bottom-0">
                                    <input type="checkbox" class="selectClient" value="<?php echo e($client->id); ?>">
                            </td>
                            <td class="border-bottom-0"><h6 class="fw-semibold mb-0"><?php echo e($loop->iteration); ?></h6></td>
                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-1"><?php echo e($client->account_username); ?></h6>
                              <span class="fw-normal"><?php echo e($client->data_package); ?></span>                          
                            </td>

                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-0 fs-4"><?php echo e($client->expiry_date); ?></h6>
                            </td>

                            <td class="border-bottom-0">
                                <div class="d-flex align-items-center gap-2">
                                    <?php if($client->status == 'Active'): ?>
                                        <span class="badge bg-secondary rounded-3 fw-semibold">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-primary rounded-3 fw-semibold">Expired</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-0 fs-4">
                                <div class="dropdown">
                                  <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Select Action
                                  </button>
                                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                     <button type="button" class="dropdown-item edit-button" data-toggle="modal" data-target="#editModal" data-id="<?php echo e($client->id); ?>" data-first_name="<?php echo e($client->first_name); ?>" data-email="<?php echo e($client->email); ?>" data-plan="<?php echo e($client->plan); ?>" data-gps="<?php echo e($client->gps); ?>" data-expiry_date="<?php echo e($client->expiry_date); ?>" data-url="<?php echo e(url('/clients')); ?>">
                                      Edit
                                    </button>

                                     <button type="button" class="dropdown-item remove-button" data-toggle="modal" data-target="#removeModal" data-id="<?php echo e($client->id); ?>" data-first_name="<?php echo e($client->first_name); ?>" data-email="<?php echo e($client->email); ?>" data-plan="<?php echo e($client->plan); ?>" data-gps="<?php echo e($client->gps); ?>" data-expiry_date="<?php echo e($client->expiry_date); ?>" data-url="<?php echo e(url('/clients')); ?>">
                                      Remove
                                    </button>
                                    
                                    <button type="button" class="dropdown-item renew-button" data-toggle="modal" data-target="#renewModal" data-id="<?php echo e($client->id); ?>" >
                                          Renew
                                    </button>
                                    
                                    <button type="button" class="dropdown-item receipts-button" data-toggle="modal" data-target="#receiptsModal" data-id="<?php echo e($client->id); ?>">
                                        Receipts
                                    </button>
                                    
                                    <button type="button" class="dropdown-item btn btn-primary view-client" id="viewClientButton" data-toggle="modal" data-target="#viewClientModal" data-id="<?php echo e($client->id); ?>">
                                        View Client
                                    </button>

                                  </div>
                                </div>
                              </h6>
                            </td>
                          </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </tbody>
                    </table>
                  </div>
                  <br>
                  <br>
                  <div class="d-flex align-items-center justify-content-end">
                    <nav aria-label="Page navigation example">
                      <ul class="pagination">
                        <li class="page-item" style="cursor: pointer;"><a class="page-link" onclick="previousPage()">Previous</a></li>
                        <li class="page-item"><a class="page-link" href="#" disabled="true"><?php echo e($page_number); ?> of <?php echo e($total_pages); ?> </a></li>
                        <li class="page-item" style="cursor: pointer;"><a class="page-link" onclick="nextPage()">Next</a></li>
                      </ul>
                    </nav> 
                  </div>
                </div>
              </div>
            </div>
          </div> 

          
          
        </div>    
      </div>
    </div>
<?php $__env->stopSection(); ?>

<!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>

page_number = 1;

clientId = '';

$(document).ready(function(){

    page_number = <?php echo $page_number; ?>;

    $(".renew-button").on('click',function(e){
        const id = $(this).data('id');

        clientId = id;
    });

    $('#addClientForm').on('submit', function(e) {
      e.preventDefault();

      // Disable the submit button
      $('#addClientSubmit').prop('disabled', true);

      var csrfToken = $('meta[name="csrf-token"]').attr('content');

      var formData = $(this).serialize();

      // Add CSRF token to form data
      formData += '&_token=' + csrfToken;

      $.ajax({
          url: `<?php echo e(url('/add-client')); ?>`, // replace with your endpoint
          type: 'POST',
          data: formData,
          success: function(response) {
              // Handle success here
              $('#addClientModal').modal('hide');
              Swal.fire(
                  'Success!',
                  'Your form has been submitted.',
                  'success'
              ).then((result) => {
                  // Reload the page when the dialog is dismissed
                  if (result.isConfirmed || result.isDismissed) {
                      location.reload();
                  }
              });

              // Enable the submit button
              $('#addClientSubmit').prop('disabled', false);
          },
          error: function(err) {
              // Handle error here
              var errorMessage = err.responseJSON.error || 'Something went wrong!';
              Swal.fire({
                  icon: 'error',
                  title: 'Oops...',
                  text: errorMessage,
                  footer: '<a href>Why do I have this issue?</a>'
              });

              // Enable the submit button
              $('#addClientSubmit').prop('disabled', false);
          }
      });
    });

    $('.view-client').on('click', function() {
      var id = $(this).data('id');

      $.ajax({
          url: `<?php echo e(url('/clients')); ?>/` + id + '/edit',
          type: 'GET',
          success: function(client) {
              // Assuming 'client' contains the JSON data
              // $('#view-accountBalance').val(client.account_balance);
              // $('#view-firstName').val(client.first_name);
              // $('#view-lastName').val(client.last_name);
              $('#view-accountUsername').val(client.account_username);
              $('#view-username').val(client.username);
              $('#view-clientId').val(client.client_id);
              $('#view-phoneNumber').val(client.phone_number);
              $('#view-email').val(client.email);
              $('#view-gps').val(client.gps);
              $('#view-plan').val(client.plan);
              $('#view-node').val(client.node);
              $('#view-expiryDate').val(client.expiry_date);
              $('#view-referalBonus').val(client.referal_bonus);
              $('#view-installationType').val(client.installation_type);
              $('#view-status').val(client.status);
              $('#view-cpeOutdoor').val(client.cpe_outdoor);
              $('#view-cpeIndoor').val(client.cpe_indoor);

              // Show the modal
              //$('#viewClientModal').modal('show');
          },
          error: function(jqXHR, textStatus, errorThrown) {
              // console.log(textStatus, errorThrown);
          }
      });
    });

    $('.edit-button').on('click', function() {
        var id = $(this).data('id');
        var url = $(this).data('url');
       
        $.ajax({
          url: `<?php echo e(url('/clients')); ?>/` + id + '/edit',
          type: 'GET',
          success: function(client) {
            // console.log(client);
            // return;
            $('#editForm').attr('action', `${url}/${client.id}`);
            $('#editForm').data('id', client.id);         
                      // Assuming 'client' contains the JSON data
            // $('#edit-accountBalance').val(client.account_balance);
            // $('#edit-firstName').val(client.first_name);
            // $('#edit-lastName').val(client.last_name);
            $('#edit-accountUsername').val(client.account_username);
            $('#edit-username').val(client.username);
            $('#edit-clientId').val(client.client_id);
            $('#edit-phoneNumber').val(client.phone_number);
            $('#edit-email').val(client.email);
            $('#edit-gps').val(client.gps);
            $('#edit-plan').val(client.plan);
            $('#edit-node').val(client.node);
            $('#edit-expiryDate').val(client.expiry_date);
            $('#edit-referalBonus').val(client.referal_bonus);
            $('#edit-installationType').val(client.installation_type);
            $('#edit-status').val(client.status);
            $('#edit-cpeOutdoor').val(client.cpe_outdoor);
            $('#edit-cpeIndoor').val(client.cpe_indoor);
          },
          
          error: function(jqXHR, textStatus, errorThrown) {
            console.log(textStatus, errorThrown);
          }
        });
    });


    $('#editForm').on('submit', function(e) {
      e.preventDefault();

      const csrfToken = $('meta[name="csrf-token"]').attr('content');

      const id = $(this).data('id');
      const url = $(this).attr('action');
      let data = $(this).serialize();

      data += '&_token=' + csrfToken;

      Swal.fire({
          title: 'Are you sure?',
          text: "You are about to update the client data.",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, update it!'
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: `<?php echo e(url('/clients')); ?>/` + id,
                  type: 'post',
                  data: data,
                  success: function(response) {
                      Swal.fire(
                          'Success!',
                          'Your form has been submitted.',
                          'success'
                      ).then((result) => {
                          if (result.isConfirmed || result.isDismissed) {
                              location.reload();
                          }
                      });
                  },
                  error: function(err) {
                      // console.log(textStatus, errorThrown);
                      let errorMessage = err.responseJSON.error || 'Something went wrong!';

                      Swal.fire({
                          icon: 'error',
                          title: 'Oops...',
                          text: errorMessage,
                      });
                  }
              });
          }
      });

      // $.ajax({
      //   url: `<?php echo e(url('/clients')); ?>/` + id,
      //   type: 'post',
      //   data: data,
      //   success: function(response) {
      //     // Handle success here, for example by updating the table or showing a success message
      //     // console.log(response);
      //     //add sweet alert here
      //     Swal.fire(
      //       'Success!',
      //       'Your form has been submitted.',
      //       'success'
      //     ).then((result) => {
      //       // Reload the page when the dialog is dismissed
      //       if (result.isConfirmed || result.isDismissed) {
      //         location.reload();
      //       }
      //     });
      //   },
      //   error: function(jqXHR, textStatus, errorThrown) {
      //     console.log(textStatus, errorThrown);
      //   }
      // });
    });

    $('.remove-button').click(function() {
        var clientId = $(this).data('id');
        var url = $(this).data('url');

        //add sweet alert here
        Swal.fire({
          title: 'Are you sure?',
          text: "You won't be able to revert this!",
          icon: 'warning', 
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
          if (result.isConfirmed) {
            $.ajax({
              url: url + '/' + clientId,
              type: 'DELETE',
              data: {
                  "_token": "<?php echo e(csrf_token()); ?>",
              },
              success: function(result) {
                 //add sweet alert
                  Swal.fire(
                    'Deleted!',
                    'Your file has been deleted.',
                    'success'
                  )
                  location.reload();
              },
              error: function(err) {
                  // add sweet alert

                  Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href>Why do I have this issue?</a>'
                  })
              }
            });
          }
        })
        
    });

    $('#renewForm').on('submit', function(e) {
      e.preventDefault();

       // Disable the submit button
      $('#renewClientSubmit').prop('disabled', true);

      //var url = '/clients/renew'; // the endpoint to submit to
      // var clientId = $('#renew-client').val();
      const packageId = $('#renew-package').val();
      const renewDate = $('#renew-date').val();
      const expiryDate = $('#renew-expiry').val();

      $.ajax({
          url: `<?php echo e(url('/renew-client')); ?>`,
          type: 'POST',
          data: {
              client_id: clientId,
              package_id: packageId,
              renew_date: renewDate,
              expiry_date: expiryDate,
              _token: '<?php echo e(csrf_token()); ?>'
          },
          success: function(response) {
              // Handle success
              // console.log(response);
              // $('#renewModal').modal('hide');
              Swal.fire(
                'Success!',
                'Your form has been submitted.',
                'success'
              ).then((result) => {
                // Reload the page when the dialog is dismissed
                if (result.isConfirmed || result.isDismissed) {
                  location.reload();
                }
              });
             $('#renewClientSubmit').prop('disabled', false);

          },
          error: function(err) {
              // Handle error
              var errorMessage = err.responseJSON.error || 'Something went wrong!';
              Swal.fire({
                  icon: 'error',
                  title: 'Oops...',
                  text: errorMessage,
                  footer: '<a href>Why do I have this issue?</a>'
              });
              $('#renewClientSubmit').prop('disabled', false);
          }
      });
    });

    $('.receipts-button').on('click', function () {
            var clientId = $(this).data('id');

            // Make an AJAX request to fetch client receipts
            $.ajax({
                url: `<?php echo e(url('/clients')); ?>/` + clientId + '/receiptsById', // Replace with your actual API endpoint
                method: 'GET',
                dataType: 'json',
                success: function (data) {
                    // Handle the retrieved receipts data
                    console.log(data);
                    displayReceipts(data.receipts);
                },
                error: function (err) {
                    var errorMessage = err.responseJSON.error || 'Something went wrong!';
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: errorMessage,
                        footer: '<a href>Why do I have this issue?</a>'
                    });
                }
            });
    });

    $('#selectAll').on('click', function() {
      // Check or uncheck all client checkboxes
      $('.selectClient').prop('checked', this.checked);
    });   

        // When the "delete selected" button is clicked
    $('#deleteSelected').on('click', function() {
        // Get all selected client IDs
        var selectedClients = $('.selectClient:checked').map(function() {
            return $(this).val();
        }).get();

        // Show a confirmation dialog
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                // User confirmed, send a DELETE request to the server
                $.ajax({
                    url: `<?php echo e(url('/delete-clients')); ?>`, // replace with your endpoint
                    type: 'DELETE',
                    data: {
                        clients: selectedClients,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        // Show a success alert and reload the page
                        Swal.fire(
                            'Deleted!',
                            'Your file has been deleted.',
                            'success'
                        ).then((result) => {
                            location.reload();
                        });
                    },
                    error: function(err) {
                        // Show an error alert
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: err.responseJSON.error,
                            footer: '<a href>Why do I have this issue?</a>'
                        });
                    }
                });
            }
        });
    });
});

function previousPage() {
  if (page_number > 1) {
    page_number--;
    window.location = `<?php echo e(url('/clients/${page_number}')); ?>`;
  }
}

function nextPage() {
  let total_pages = <?php echo json_encode($total_pages); ?>;
  if (total_pages > page_number) {
    page_number++;
    window.location = `<?php echo e(url('/clients/${page_number}')); ?>`;
  }
}

function displayReceipts(receipts) {
    // Assuming you have a table body with ID 'receiptsTableBody'
    var tableBody = $('#receiptsTableBody');

    // Clear previous content
    tableBody.empty();

    // Append each receipt to the table body
    $.each(receipts, function (index, receipt) {
        tableBody.append('<tr>' +
            '<td>' + receipt.renew_date + '</td>' +
            '<td>' + receipt.data_package + '</td>' +
            '<td>' + receipt.expiry_date + '</td>' +
            '<td><button class="btn btn-primary">View</button></td>' +
            '</tr>');
    });
}

function uploadFile() {
    $('#excelFile').click();
    $('#excelFile').on('change', function() {
        var file = this.files[0];
        var formData = new FormData();
        formData.append('file', file);

        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        formData.append('_token', csrfToken);

        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to import clients from the selected file.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, import it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(url('/import-clients')); ?>",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        Swal.fire(
                            'Imported!',
                            'Your file has been imported.',
                            'success'
                        ).then((result) => {
                            location.reload();
                        });
                    },
                    error: function(err) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: err.responseJSON.error,
                            footer: '<a href>Why do I have this issue?</a>'
                        });
                    }
                });
            }
        });
    });
}

// function uploadFile() {
//     $('#excelFile').click();
//     $('#excelFile').on('change', function() {
//         var file = this.files[0];
//         var formData = new FormData();
//         formData.append('file', file);

//         var csrfToken = $('meta[name="csrf-token"]').attr('content');
//         formData.append('_token', csrfToken);

//         $.ajax({
//             url: "<?php echo e(url('/import-clients')); ?>",
//             type: 'POST',
//             data: formData,
//             processData: false,
//             contentType: false,
//             success: function(response) {
//                 //console.log(response);
               
//             },
//             error: function(err) {
//                 Swal.fire({
//                     icon: 'error',
//                     title: 'Oops...',
//                     text: 'Something went wrong!',
//                     footer: '<a href>Why do I have this issue?</a>'
//                 });
//             }
//         });
//     });
// }
</script>
    
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>