<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.datatables.buttons.min.css')); ?>">
<div class="row">
    <div class="col-12">
        <h3 class="">Requested Transcripts</h3><br>
        <div class="card flex-fill">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <button class="btn btn-primary text-white" onclick="reload()"><i
                                class="fas fa-sync me-1"></i>Reload</button>
                    </div>
                    <div></div>
                </div>
            </div>
            <table id="dataTable-1" class="table table-striped  my-0">
                <thead>
                    <tr>
                        <th>Tracking No</th>
                        <th>Index Number</th>
                        <th class="d-none d-xl-table-cell">Applicant Name</th>
                        <th class="d-none d-xl-table-cell">Tel</th>
                        <th>Email Address</th>
                        <th>Type of Document</th>
                        <th>Delivery Mode</th>
                        <th>Status</th>
                        <th class="d-none d-md-table-cell">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ordered_documents as $ordered_document) {
                        $tracking_no = $ordered_document['tracking_no'];
                                ?>
                    <tr>
                        <td><?php echo e($ordered_document['tracking_no']); ?></td>
                        <td><?php echo e($ordered_document['index_no']); ?></td>
                        <td><?php echo e($ordered_document['applicant_name']); ?> </td>
                        <td><?php echo e($ordered_document['phone_no']); ?> </td>
                        <td><?php echo e($ordered_document['emailaddress']); ?> </td>
                        <td> <?php echo e($ordered_document['type_of_document']); ?> </td>
                        <td> <?php echo e($ordered_document['delivery_mode']); ?> </td>
                        <td><span class="badge bg-warning"> <?php echo e($ordered_document['status']); ?> </span></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <a class="btn btn-light mr-2 ms-2" title="View details"
                                    href="<?php echo route('transcript-details', ['tracking_no' => $tracking_no]); ?>">
                                    <i class="align-middle text-warning" data-feather="file-text"></i>
                                </a>
                                <a class="btn btn-light mr-2 ms-2" title="View complaints">
                                    <i class="align-middle" data-feather="message-square"></i>
                                </a>
                            </div>
                        </td>
                    </tr>

                    <?php }?>
                </tbody>
            </table>
        </div>
    </div>


    <script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>

    <script>
    $(document).ready(function() {
        $('#dataTable-1').DataTable({
            dom: 'Bfrtip',
            buttons: [
                // 'copy', 'csv', 'excel', 'pdf', 'print'
                {
                    extend: 'copy',
                    footer: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'pdf',
                    footer: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'csv',
                    footer: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'excel',
                    footer: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'print',
                    footer: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
            ]
        });

        $(function() {
            $('select').select2();
        });
    });

    function reload() {
        window.location.reload();
    }

    function toggleDocumentStatus(tracking_no) {
        const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
        let body = {
            tracking_no: tracking_no,
            _token: csrfToken
        }

        Swal.fire({
            title: 'Info',
            text: 'Do you want to save privillages?',
            icon: 'question',
            confirmButtonText: 'Yes',
            showCancelButton: true,
            cancelButtonText: 'No',
            confirmButtonColor: '#1cc88a',
            cancelButtonColor: '#d33',

        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `<?php echo e(url('/toggle-document-status')); ?>`,
                    method: 'POST',
                    data: body,
                    success: function(result_) {
                        Swal.fire({
                            title: 'Info',
                            text: result_ == 'success' ?
                                'Document status has been toggled successfully!' :
                                'Document status could not be toggled!',
                            icon: result_,
                            confirmButtonText: 'Okay',
                            confirmButtonColor: '#1cc88a'

                        }).then((result) => {
                            window.location.reload();
                        })
                    }
                });

            }
        });
    }
    </script>