<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/stepper.css')); ?>">

<?php $__env->startSection('content'); ?>
<section style="margin-top: 100px;">
    <div class="stepper-horizontal" id="stepper1">
        <div class="step editing">
            <div class="step-circle"><span>1</span></div>
            <div class="step-title">Transaction Id</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
        <div class="step">
            <div class="step-circle"><span>2</span></div>
            <div class="step-title">Transcript Details</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
    </div>
    <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2 col-sm-12">
        <div class="card shadow col-12" id="track-document">
            <div class="card-body bg-white" style="background-color: white;">
                <form id="verification-form">
                    <div class="row">
                        <div id="transaction_id_verification">
                            <div class="col-lg-10 offset-lg-1 col-sm-12">
                                <div class="form-group">
                                    <label for="tracking_no">Enter Tracking Number</label>
                                    <input type="text" class="form-control" id="tracking_no" name="tracking_no" />
                                    <button type="button" class="btn bg-primary text-white me-2"
                                        style="margin-top: 10px;" onclick="getTranscriptDetails()"><i
                                            class="fas fa-save mr-1"></i>Track
                                        Document</button>
                                    <button type="button" class="btn btn-sm bg-secondary text-white"
                                        style="margin-top: 10px;" onclick="previewFile()"><i
                                            class="fas fa-file me-1"></i>View Results</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div id="transcript-details" class="card flex-fill">
            <div class="card" id="transcript-details-1">
                <div class="card-header">
                    <h3 class="">Document Details</h3><br>
                </div>
                <div class="card-body">
                    <table class="table table-striped" id="transcript-document">
                        <tbody id="transcript_document">

                        </tbody>
                    </table>
                </div>
            </div>
            <div class="d-flex align-items-center pl-2 pb-2">
                <button type="button" class="btn btn-primary text-white" onclick="showComplaintDialog()"
                    style="margin-right: 10px;"><i class="fas fa-comment me-1"></i>Make a Complain</button>
                <button type="button" class="btn btn-secondary" type="button"
                    onclick="printDiv('transcript-details-1')"><i class="fas fa-print me-1"></i>Print</button>

            </div>
        </div>
    </div>

    <div class="modal fade" id="comment_modal" tabindex="-1" role="dialog" aria-labelledby="addCommentModal"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h3 id="addCommentModal">Write Your Complain</h3>

                        <button type="button" class="btn btn-sm bg-danger text-white" class="close" data-dismiss="modal"
                            aria-label="Close">
                            <span aria-hidden="true" style="color: white;">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="col-12 mb-2">
                        <label for="complaint">Complaint</label>
                        <textarea class="form-control" name="complaint" id="complaint" cols="30" rows="10"></textarea>
                    </div>

                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn bg-primary text-white ms-2" onclick="makeAComplain()"><i
                                class="fas fa-save mr-1"></i>Save</button>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="preview-document" tabindex="-1" role="dialog" aria-labelledby="previewUploadFileLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewUploadFileLabel">Preview File</h5>

                    <button type="button" class="btn btn-sm bg-danger text-white" onclick="dismissPreviewModal()"
                        class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true" style="color: white;">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="previewPdfContainer">

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/printThis.js')); ?>"></script>
<script>
var currentStep = 1;
var numSteps = 2;
$(document).ready(function() {
    $('#track-document').show();
    $("#transcript-details").hide();
});

function showComplaintDialog() {
    $('#comment_modal').modal({
        backdrop: 'static',
        keyboard: false
    }, 'show');
}

function previewResults() {

}

function printDocument() {
    $('#transcript-document').printThis();
}

function makeAComplain() {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let tracking_no = document.getElementById('tracking_no').value;
    let complain = document.getElementById('complaint').value;
    let body = {
        tracking_no: tracking_no,
        complain: complain,
        _token: csrfToken
    }
    console.log(body);
    Swal.fire({
        title: 'Info',
        text: 'Do you want to submit?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/make-a-complain')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'Complaint have been submitted successfully!' :
                            'Complaint could not be submitted.',
                        icon: 'info',
                        confirmButtonText: 'Yes',
                        showCancelButton: true,
                        cancelButtonText: 'No',
                        confirmButtonColor: '#1cc88a',
                        cancelButtonColor: '#d33'
                    }).then(res => {
                        window.location.reload();
                    })
                }
            });
        }
    });
}

function nextStep() {
    currentStep++;
    if (currentStep > numSteps) {
        currentStep = 1;
    }

    if (currentStep == 1) {
        $("#track-document").show();
        $("#transcript-details").hide();
    } else if (currentStep == 2) {
        $("#track-document").hide();
        $("#transcript-details").show();
    }

    var stepper = document.getElementById('stepper1');
    var steps = stepper.getElementsByClassName('step');

    Array.from(steps).forEach((step, index) => {
        let stepNum = index + 1;
        if (stepNum === currentStep) {
            addClass(step, 'editing');
        } else {
            removeClass(step, 'editing');
        }
        if (stepNum < currentStep) {
            addClass(step, 'done');
        } else {
            removeClass(step, 'done');
        }
    });

    console.log(currentStep);
}

function printDiv(divName) {
    var printContents = document.getElementById(divName).innerHTML;
    var originalContents = document.body.innerHTML;

    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;
}

function getTranscriptDetails() {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let tracking_no = document.getElementById('tracking_no').value;
    if (!tracking_no) {
        Swal.fire({
            title: 'Info',
            text: 'Please specify the tracking no',
            icon: 'error',
            confirmButtonText: 'Okay',
            confirmButtonColor: '#1cc88a'
        });

        return;
    }
    
    let body = {
        tracking_no: tracking_no,
        _token: csrfToken
    }

    $.ajax({
        url: `<?php echo e(url('/transcript-details')); ?>`,
        method: 'POST',
        data: body,
        success: function(result_) {
            document.getElementById('tracking_no').value = "";
            if (result_ != 'failed') {
                console.log(result_);
                let tracking_no = result_['tracking_no'];
                let index_no = result_['index_no'];
                let applicant_name = result_['applicant_name'];
                let emailaddress = result_['emailaddress'];
                let contact = result_['phone_no'];
                let year_of_admission = result_['year_of_admission'];
                let year_of_completion = result_['year_of_completion'];
                let program = result_['program'];
                let type_of_document = result_['type_of_document'];
                let delivery_mode = result_['delivery_mode'];
                let postal_address = result_['postal_address'];

                let document_status = result_['status'];

                let arr = [{
                        key: 'Tracking No',
                        value: tracking_no
                    },
                    {
                        key: 'Index No',
                        value: index_no
                    },
                    {
                        key: 'Applicant Name',
                        value: applicant_name
                    },
                    {
                        key: 'Email Address',
                        value: emailaddress
                    },
                    {
                        key: 'Contact',
                        value: contact
                    },
                    {
                        key: 'Year of Admission',
                        value: year_of_admission
                    },
                    {
                        key: 'Year of Completion',
                        value: year_of_completion
                    },
                    {
                        key: 'Program',
                        value: program
                    },
                    {
                        key: 'Type of Document',
                        value: type_of_document
                    },
                    {
                        key: 'Delivery Mode',
                        value: delivery_mode
                    },
                    {
                        key: 'Postal Address',
                        value: postal_address
                    },
                    {
                        key: 'Document Status',
                        value: document_status
                    }
                ]
                renderTable(arr);
                nextStep();
            } else {
                Swal.fire({
                    title: 'Info',
                    text: 'Requested document does not exists!',
                    icon: 'error',
                    confirmButtonText: 'Okay',
                    confirmButtonColor: '#1cc88a'
                })
            }
        }
    });


}

function renderTable(user_information_) {
    $('#transcript_document td').parent().remove();
    user_information_.forEach((user_info, user_info_index) => {
        let tb = $('#transcript_document');
        let tr = $(`<tr id=""></tr>`);
        let key = $(`<td> <b>${user_info.key }</b></td>`);
        let value = $(`<td> ${user_info.value }</td>`);
        tr.append(key);
        tr.append(value);
        tb.append(tr);
    });
}

function previewFile() {
    let tracking_no = document.getElementById('tracking_no').value;
    if (!tracking_no) {
        Swal.fire({
            title: 'Info',
            text: 'Please specify the tracking no',
            icon: 'error',
            confirmButtonText: 'Okay',
            confirmButtonColor: '#1cc88a'

        })
        return;
    }

    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let formData = {
        tracking_no: tracking_no,
        _token: csrfToken
    }

    $.ajax({
        url: `<?php echo e(url('/preview-uploaded-document')); ?>`,
        type: 'POST',
        data: formData,
        success: function(data) {
            if (data == "failed") {
                Swal.fire({
                    title: 'Info',
                    text: 'No document have been uploaded yet!',
                    icon: 'error',
                    confirmButtonText: 'Okay',
                    confirmButtonColor: '#1cc88a'

                })
                return;
            }

            previewPdf(`<?php echo e(url('${data}')); ?>`);
        },
        error: function(xhr, status, error) {
            console.log('Error uploading file: ' + error);
        }
    });
}

function previewPdf(pdfUrl) {
    var pdfId = document.getElementById("previewPdfContainer");
    pdfId.removeChild(pdfId.childNodes[0]);
    var embed = document.createElement('embed');
    embed.style.width = "100%";
    embed.style.height = "700px";
    embed.setAttribute('src', pdfUrl);
    embed.setAttribute('type', 'application/pdf');
    pdfId.appendChild(embed);
    $('#preview-document').modal('show');
}

function dismissPreviewModal() {
    $('#preview-document').modal('hide');
}
</script>
<?php echo $__env->make('master_content', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>