<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>Nerve Tech Client Management System</title>
  <!-- <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('assets/images/logos/favicon.png')); ?>" /> -->
  <link rel="stylesheet" href="<?php echo e(asset('public/css/styles.min.css')); ?>" />

</head>
<body>
  <!--  Body Wrapper -->
  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
    data-sidebar-position="fixed" data-header-position="fixed">
    <div
      class="position-relative overflow-hidden radial-gradient min-vh-100 d-flex align-items-center justify-content-center">
      <div class="d-flex align-items-center justify-content-center w-100">
        <div class="row justify-content-center w-100">
          <div class="col-md-8 col-lg-6 col-xxl-3">
            <div class="card mb-0">
              <div class="card-body">
                <a href="./index.html" class="text-nowrap logo-img text-center d-block py-3 w-100">
                  <img src="../assets/images/logos/dark-logo.svg" width="180" alt="">
                </a>
                <p class="text-center">Nerve Tech Client Management System</p>
                <form id="signIn">
                  <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Username</label>
                    <input type="email" class="form-control" id="userEmail" aria-describedby="emailHelp">
                  </div>
                  <div class="mb-4">
                    <label for="exampleInputPassword1" class="form-label">Password</label>
                    <input type="password" class="form-control" id="userPassword">
                  </div>
                  <div class="d-flex align-items-center justify-content-between mb-4">
                    <div class="form-check">
                      <input class="form-check-input primary" type="checkbox" value="" id="flexCheckChecked" checked>
                      <label class="form-check-label text-dark" for="flexCheckChecked">
                        Remeber this Device
                      </label>
                    </div>
                    <a class="text-primary fw-bold" href="<?php echo e(url('/')); ?>">Forgot Password ?</a>
                  </div>
                    
                    <button type="submit" class="btn btn-primary w-100 py-8 fs-4 mb-4 rounded-2">Sign In</button>

                    <div class="d-flex align-items-center justify-content-center">
                    <p class="fs-4 mb-0 fw-bold"></p>
                    <a class="text-primary fw-bold ms-2" href="<?php echo e(url('/clients/1')); ?>">Create an account</a>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<script src="<?php echo e(asset('public/libs/jquery/dist/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
  $(document).ready(function() {
      $('#signIn').on('submit', function(e) {
          e.preventDefault();

          const email = $('#userEmail').val();
          const password = $('#userPassword').val();

          $.ajax({
              url: `<?php echo e(url('/login')); ?>`,
              type: 'POST',
              data: {
                  email: email,
                  password: password,
                  _token: $('meta[name="csrf-token"]').attr('content')
              },
              success: function(response) {
                    if (response.status === 'success') {
                        // Redirect to the provided URL
                        window.location.href = `<?php echo e(url('${response.redirect}')); ?>`;
                    } else {
                        // Handle error here
                         Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: response.message,
                        }); 
                    }
              },
              error: function(err) {
                  // Handle error here
                   Swal.fire({
                      icon: 'error',
                      title: 'Oops...',
                      text: response.message,
                  });
              }
          });
      });
  });
</script>
</body>
</html>