
<?php $__env->startSection('content'); ?>
    <section>
        <div class="col-lg-8 col-md-10 col-sm-12 mt-5 ms-3">
            <div class="card">
                
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h2 ><?php echo e($title); ?></h2>
                    <a href="<?php echo url('system-users'); ?>" class="btn btn-primary text-white"><i class="fas fa-users mr-1"></i>View
                        System Users</a>
                </div>

                <div class="card-content collapse show">
                    <div class="card-body">
                        <div class="users-list-filter">
                            <form id="create_user" method="POST">
                            <?php echo csrf_field(); ?>

                                <div class="row">
                                    <div class="col-12">
                                        <input type="number" style="display: none;" id="user_id" name="user_id"
                                            value="<?php echo e($system_user->id); ?>" required>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="firstname"><b>First Name</b></label>
                                            <input type="text" id="firstname" class="form-control" name="firstname"
                                                value="<?php echo e($system_user->firstname); ?>" required />
                                            <small>Enter firstname</small>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="lastname"><b>Last Name</b></label>
                                            <input type="text" id="lastname" class="form-control" name="lastname"
                                                value="<?php echo e($system_user->lastname); ?>" required required />
                                            <small>Enter lastname</small>
                                        </div>
                                    </div>

                                    <div class="col-6 mt-2">
                                        <div class="form-group">
                                            <label for="emailaddress"><b>Email Address</b></label>
                                            <input type="emailaddress" id="emailaddress" class="form-control"
                                                name="emailaddress" value="<?php echo e($system_user->emailaddress); ?>" required
                                                required onkeyup="checkIfEmailIsValid()" />
                                            <small id="enter-emailaddress">Enter emailaddress</small>
                                            <small id="emailaddress-error" style="color: crimson;">Invalid
                                                emailaddress</small>
                                        </div>
                                    </div>

                                    <div class="col-6 mt-2 ">
                                        <div class="form-group">
                                            <label for="designation"><b>Designation</b></label>
                                            <select id="designation" name="designation" class="form-control" required>
                                                <option disabled value="--Select--" selected>--Select--</option>
                                                <?php foreach ($designations as $key => $value): ?>
                                                
                                                <option value="<?php echo e($value['id']); ?>"
                                                    selected="<?php echo e($system_user->designation); ?>"><?php echo e($value['name']); ?></option>
                                                <?php endforeach ?>
                                            </select>
                                            <small>Select designation</small>
                                        </div>
                                    </div>

                                    <div class="col-6 mt-2 ">
                                        <div class="form-group">
                                            <label for="phone"><b>Tel</b></label>
                                            <input type="tel" id="phone" class="form-control" name="phone"
                                                value="<?php echo e($system_user->phone); ?>" required />
                                            <small>Enter telephone number</small>
                                        </div>
                                    </div>

                                    <div class="col-6 mt-2">
                                        <div class="form-group">
                                            <label for="password"><b>Password</b></label>
                                            <input type="password" id="password" class="form-control"
                                                value="<?php echo e($system_user->phone); ?> " name="password" required />
                                            <small>Enter password</small>
                                        </div>
                                    </div>

                                    <div class="col-12 mt-2">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div></div>
                                            <button class="btn btn-primary text-white btn-xl" style="float: right;"
                                                onclick="saveUser()" type="button">
                                                <div id="add-user">
                                                    <i class="fas fa-user-tie me-1"></i>Submit
                                                </div>
                                                <div id="progress-indicator" style="display: none;">
                                                    <span class="spinner-border spinner-border-sm" role="status"
                                                        aria-hidden="true"></span>
                                                    Saving...
                                                </div>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>

<script>
    function checkIfEmailIsValid() {
        let emailaddress = $('#emailaddress').val();
        if (!(emailaddress.endsWith('@gmail.com')) && !(emailaddress.endsWith('@yahoo.com'))) {
            console.log('Emailaddres is inavalid');
            $("#enter-emailaddress").remove();
            $("#emailaddress-error").show();
        } else {
            console.log('Emailaddress is valid');
            $("#enter-emailaddress").show();
            $("#emailaddress-error").remove();
        }
    }

    function saveUser() {
        const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
        var formData = $('form').serializeArray();
        let req_body = {
            user_id: getValue(formData, 'user_id'),
            firstname: getValue(formData, 'firstname'),
            lastname: getValue(formData, 'lastname'),
            emailaddress: getValue(formData, 'emailaddress'),
            designation: getValue(formData, 'designation'),
            privillages: "[]",
            phone: getValue(formData, 'phone'),
            password: getValue(formData, 'password'),
            created_at: new Date().toLocaleDateString(),
            _token: csrfToken
        };

        Swal.fire({
            title: 'Info',
            text: 'Do you want to submit?',
            icon: 'question',
            confirmButtonText: 'Yes',
            showCancelButton: true,
            cancelButtonText: 'No',
            confirmButtonColor: '#1cc88a',
            cancelButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                $("#add-user").hide();
                $("#progress-indicator").show();
                $.ajax({
                    url: `<?php echo e(url('/save-system-user')); ?>`,
                    method: 'POST',
                    data: req_body,
                    success: function(result_) {
                        $("#add-user").show();
                        $("#progress-indicator").hide();
                        Swal.fire({
                            title: 'Info',
                            text: result_ == 'success' ?
                                'User has been saved successfully!' :
                                'User could not be created!',
                            icon: result_,
                            confirmButtonText: 'Okay',
                            confirmButtonColor: '#1cc88a'

                        }).then((result) => {
                            location.reload();
                        })
                    }
                });

            } else if (result.isDenied) {
                Swal.fire('Changes are not saved', '', 'info')
            }

        })



    }

    function getValue(arr, key) {
        let value_index = arr.findIndex(obj => obj.name == key);
        if (value_index != -1) {
            return arr[value_index]['value'];
        } else {
            return 'Value does not exists';
        }
    }

    document.onreadystatechange = () => {
        if (document.readyState === 'complete') {
            var system_user = <?php echo json_encode($system_user); ?>;
            $("#designation").val(system_user['designation']).change();
            if (system_user['id'] == '0') {
                $
                document.getElementById('password').value = '';
            } else {
                document.getElementById('password').value = system_user['password'];
            }

            $("#enter-emailaddress").show();
            $("#emailaddress-error").remove();
        }
    }
</script>

<?php echo $__env->make('master_view', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>