<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/stepper.css')); ?>">

<?php $__env->startSection('content'); ?>
<section style="margin-top: 100px;">
    <div class="stepper-horizontal" id="stepper1">
        <div class="step editing">
            <div class="step-circle"><span>1</span></div>
            <div class="step-title">Transaction Id</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
        <div class="step">
            <div class="step-circle"><span>2</span></div>
            <div class="step-title">Transcript Details</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
    </div>
    <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2 col-sm-12">
        <div class="card shadow col-12" id="track-document">
            <div class="card-body bg-white" style="background-color: white;">
                <form id="verification-form">
                    <div class="row">
                        <div id="transaction_id_verification">
                            <div class="col-lg-10 offset-lg-1 col-sm-12">
                                <div class="form-group">
                                    <label for="tracking_no">Enter Tracking Number</label>
                                    <input type="text" class="form-control" id="tracking_no" name="tracking_no" />
                                    <button type="button" class="btn bg-primary text-white" style="margin-top: 10px;"
                                        onclick="getTranscriptDetails()"><i class="fas fa-save mr-1"></i>Track
                                        Document</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div id="transcript-details" class="card flex-fill">
            <div class="card-header">
                <h3 class="">Transcript Details</h3><br>
            </div>
            <div class="card-body">
                <table class="table table-striped" id="transcript-document">
                    <tbody id="transcript_document">

                    </tbody>
                </table>

                <div class="d-flex align-items-center">
                    <button type="button" class="btn btn-primary text-white" onclick="showComplaintDialog()"
                        style="margin-right: 10px;"><i class="fas fa-comment me-1"></i>Make a Complain</button>
                    <button class="btn btn-secondary" onclick="printDocument()"><i
                            class="fas fa-print me-1"></i>Print</button>

                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="comment_modal" tabindex="-1" role="dialog" aria-labelledby="addCommentModal"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h3 id="addCommentModal">Write Your Complain</h3>

                        <button type="button" class="btn btn-sm bg-danger text-white" class="close" data-dismiss="modal"
                            aria-label="Close">
                            <span aria-hidden="true" style="color: white;">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <div class="col-12 mb-2">
                        <label for="complaint">Complaint</label>
                        <textarea class="form-control" name="complaint" id="complaint" cols="30" rows="10"></textarea>
                    </div>

                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn bg-primary text-white ms-2" onclick="makeAComplain()"><i
                                class="fas fa-save mr-1"></i>Save</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/printThis.js')); ?>"></script>
<script>
var currentStep = 1;
var numSteps = 2;
$(document).ready(function() {
    $('#track-document').show();
    $("#transcript-details").hide();
});

function showComplaintDialog() {
    $('#comment_modal').modal({
        backdrop: 'static',
        keyboard: false
    }, 'show');
}

function printDocument() {
    $('#transcript-document').printThis();
}

function makeAComplain() {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let tracking_no = document.getElementById('tracking_no').value;
    let complain = document.getElementById('complaint').value;
    let body = {
        tracking_no: tracking_no,
        complain: complain,
        _token: csrfToken
    }
    console.log(body);
    Swal.fire({
        title: 'Info',
        text: 'Do you want to submit?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/make-a-complain')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'Complaint have been submitted successfully!' :
                            'Complaint could not be submitted.',
                        icon: 'info',
                        confirmButtonText: 'Yes',
                        showCancelButton: true,
                        cancelButtonText: 'No',
                        confirmButtonColor: '#1cc88a',
                        cancelButtonColor: '#d33'
                    }).then(res => {
                        window.location.reload();
                    })
                }
            });
        }
    });
}

function nextStep() {
    currentStep++;
    if (currentStep > numSteps) {
        currentStep = 1;
    }

    if (currentStep == 1) {
        $("#track-document").show();
        $("#transcript-details").hide();
    } else if (currentStep == 2) {
        $("#track-document").hide();
        $("#transcript-details").show();
    }

    var stepper = document.getElementById('stepper1');
    var steps = stepper.getElementsByClassName('step');

    Array.from(steps).forEach((step, index) => {
        let stepNum = index + 1;
        if (stepNum === currentStep) {
            addClass(step, 'editing');
        } else {
            removeClass(step, 'editing');
        }
        if (stepNum < currentStep) {
            addClass(step, 'done');
        } else {
            removeClass(step, 'done');
        }
    });

    console.log(currentStep);
}


function getTranscriptDetails() {
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let tracking_no = document.getElementById('tracking_no').value;
    let body = {
        tracking_no: tracking_no,
        _token: csrfToken
    }
    console.log(body);
    Swal.fire({
        title: 'Info',
        text: 'Do you want to submit?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/transcript-details')); ?>`,
                method: 'POST',
                data: body,
                success: function(result_) {
                    document.getElementById('tracking_no').value = "";
                    if (result_ != 'failed') {
                        console.log(result_);
                        let tracking_no = result_['tracking_no'];
                        let index_no = result_['index_no'];
                        let applicant_name = result_['applicant_name'];
                        let emailaddress = result_['emailaddress'];
                        let year_of_admission = result_['year_of_admission'];
                        let year_of_completion = result_['year_of_completion'];
                        let program = result_['program'];
                        let type_of_document = result_['type_of_document'];
                        let delivery_mode = result_['delivery_mode'];
                        let postal_address = result_['postal_address'];

                        let document_status = result_['status'];

                        let arr = [{
                                key: 'Tracking No',
                                value: tracking_no
                            },
                            {
                                key: 'Index No',
                                value: index_no
                            },
                            {
                                key: 'Applicant Name',
                                value: applicant_name
                            },
                            {
                                key: 'Email Address',
                                value: emailaddress
                            },
                            {
                                key: 'Year of Admission',
                                value: year_of_admission
                            },
                            {
                                key: 'Year of Completion',
                                value: year_of_completion
                            },
                            {
                                key: 'Program',
                                value: program
                            },
                            {
                                key: 'Type of Document',
                                value: type_of_document
                            },
                            {
                                key: 'Delivery Mode',
                                value: delivery_mode
                            },
                            {
                                key: 'Postal Address',
                                value: postal_address
                            },
                            {
                                key: 'Document Status',
                                value: document_status
                            }
                        ]
                        renderTable(arr);
                        nextStep();
                    } else {
                        Swal.fire({
                            title: 'Info',
                            text: 'Requested document does not exists!',
                            icon: 'error',
                            confirmButtonText: 'Okay',
                            confirmButtonColor: '#1cc88a'
                        })
                    }
                }
            });
        }
    });


}

// <
// tr >
//     <
//     td > < b > Tracking No: < /b></td >
//     <
//     td class = "text-truncate" > {
//         {
//             $ordered_document['tracking_no']
//         }
//     } < /td> <
//     /tr> <
//     tr >
//     <
//     td > < b > Index No: < /b></td >
//     <
//     td > {
//         {
//             $ordered_document['index_no']
//         }
//     } < /td> <
//     /tr> <
//     tr >
//     <
//     td > < b > Applicant Name: < /b></td >
//     <
//     td > {
//         {
//             $ordered_document['applicant_name']
//         }
//     } < /td> <
//     /tr>

//     <
//     tr >
//     <
//     td > < b > Email Address: < /b></td >
//     <
//     td > {
//         {
//             $ordered_document['emailaddress']
//         }
//     } < /td> <
//     /tr>

//     <
//     tr >
//     <
//     td > < b > Type of Document: < /b></td >
//     <
//     td > {
//         {
//             $ordered_document['type_of_document']
//         }
//     } < /td> <
//     /tr>

//     <
//     tr >
//     <
//     td > < b > Delivery Mode: < /b></td >
//     <
//     td > {
//         {
//             $ordered_document['delivery_mode']
//         }
//     } < /td> <
//     /tr>

//     <
//     tr >
//     <
//     td > < b > Postal Address: < /b></td >
//     <
//     td >
//     <
//     div > {
//         {
//             $ordered_document['postal_address']
//         }
//     } < /div> <
//     /td> <
//     /tr>

//     <
//     tr >
//     <
//     td > < b > Document Status: < /b></td >
//     <
//     td >
//     <
//     span class = "badge bg-warning" > {
//         {
//             $ordered_document['status']
//         }
//     } < /span> <
//     /td> <
//     /tr> -->

function renderTable(user_information_) {
    $('#transcript_document td').parent().remove();
    user_information_.forEach((user_info, user_info_index) => {
        let tb = $('#transcript_document');
        let tr = $(`<tr id=""></tr>`);
        let key = $(`<td> <b>${user_info.key }</b></td>`);
        let value = $(`<td> ${user_info.value }</td>`);
        tr.append(key);
        tr.append(value);
        tb.append(tr);
    });
}
</script>
<?php echo $__env->make('master_content', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>