<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/stepper.css')); ?>">


<?php $__env->startSection('content'); ?>
<section style="margin-top: 100px;">
    <div class="stepper-horizontal" id="stepper1">
        <div class="step editing">
            <div class="step-circle"><span>1</span></div>
            <div class="step-title">Verification Page</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
        <div class="step">
            <div class="step-circle"><span>2</span></div>
            <div class="step-title">Student Information</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>

        <div class="step">
            <div class="step-circle"><span>3</span></div>
            <div class="step-title">Summary</div>
            <div class="step-bar-left"></div>
            <div class="step-bar-right"></div>
        </div>
    </div>


    <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2 col-sm-12">

        <div class="card shadow col-12" id="verification">
            <div class="card-body bg-white" style="background-color: white;">
                <form id="verification-form">
                    <div class="row">
                        <div id="transaction_id_verification">
                            <div class="col-lg-10 offset-lg-1 col-sm-12">
                                <div class="form-group">
                                    <label for="transaction_id">Enter Transaction ID</label>
                                    <input type="text" class="form-control" id="transaction_id" name="transaction_id" />
                                    <button id="transaction-id-btn" type="button" class="btn bg-primary text-white"
                                        style="margin-top: 10px;" onclick="verifyApplicant()">
                                        <div id="verify-transaction-id-label">Verify</div>
                                        <div id="verify-transaction-id-spinner" class="spinner-border" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                    </button>
                                </div>
                            </div>

                        </div>
                        <div id="index_number_verification">

                            <div class="col-lg-10 offset-lg-1 col-sm-12">
                                <div class="form-group">
                                    <label for="index_number">Enter Index Number Used In School</label>
                                    <input type="text" class="form-control" id="index_number" name="index_number" />
                                    <button id="verify-index-btn" class="btn bg-primary text-white" type="button"
                                        style="margin-top: 15px;" onclick="verifyIndexNumber()">
                                        <div id="verify-index-label">
                                            Verify
                                        </div>
                                        <div id="verify-index-spinner" class="spinner-border" role="status">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                    </button>
                                    <button class="btn bg-secondary text-white" style="margin-top: 15px;"
                                        onclick="restart()">Back</button>
                                </div>
                            </div>
                        </div>

                        <div id="user-info">
                            <div class="col-lg-10 offset-lg-1 col-sm-12" style="margin-top: 10px;">
                                <table class="table table-striped" style="margin-top: 15px;">
                                    <tbody id="user_information_table">

                                    </tbody>
                                </table>

                                <button class="btn btn-primary text-white mr-1" type="button" onclick="thatIsMe()">That
                                    Is
                                    Me</button>
                                <button class="btn btn-danger text-white mr-1" type="button" onclick="notMe()">Not
                                    Me</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>

        <div class="col-12">
            <div class="col-12-12 p-2" style="margin-top: 10px;">
                <div class="card shadow" id="enter-information">
                    <div class="card-body">
                        <form id="user-information">
                            <div class="row">
                                <center>
                                    <h2 id="document-title"><b>Transcript</b></h2>
                                </center>

                                <div id="local-delivery">
                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="index_no"><b>Index Number</b></label>
                                        <input type="text" class="form-control" id="index_no" name="index_no">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="applicant_name"><b>Applicant Name</b></label>
                                        <input type="text" class="form-control" id="applicant_name"
                                            name="applicant_name">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="phone_number"><b>Phone Number</b></label>
                                        <input type="text" class="form-control" id="phone_number" name="phone_number">
                                    </div>


                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="emailaddress"><b>Email Address</b></label>
                                        <input type="text" class="form-control" id="emailaddress" name="emailaddress">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="date_of_birth"><b>Date of Birth</b></label>
                                        <input type="date" class="form-control" id="date_of_birth" name="date_of_birth">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_admission"><b>Year of Admission</b></label>
                                        <input type="text" class="form-control" id="year_of_admission"
                                            name="year_of_admission">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_completion"><b>Year of Completion</b></label>
                                        <input type="text" class="form-control" id="year_of_completion"
                                            name="year_of_completion">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="program"><b>Programmes</b></label>
                                        <select class="form-control select program mr-2" name="program" id="program"
                                            required>
                                            <?php   foreach ($programmes as $key => $value):?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="delivery_mode"><b>Delivery Mode</b></label>
                                        <input type="text" class="form-control" id="delivery_mode" name="delivery_mode">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="country"><b>Country</b></label>
                                        <select class="form-control select country mr-2" name="country" id="country"
                                            required>
                                            <?php   foreach ($countries as $key => $value):?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-12 col-sm-12" style="margin-top: 10px;">
                                        <label for="postal_address"><b>Postal
                                                Address</b></label>
                                        <textarea type="text" class="form-control" id="postal_address"
                                            name="postal_address" cols="4" rows="4"></textarea>
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <div>
                                            <button class="btn btn-primary text-white mr-2" type="button"
                                                onclick="showSummaryLocalDelivery()">Proceed</button>
                                            <button class="btn bg-secondary text-white"
                                                onclick="restart()">Back</button>
                                        </div>
                                    </div>

                                </div>

                                <div id="international-delivery">
                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="index_no_int"><b>Index Number</b></label>
                                        <input type="text" class="form-control" id="index_no_int" name="index_no_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="applicant_name_int"><b>Applicant Name</b></label>
                                        <input type="text" class="form-control" id="applicant_name_int"
                                            name="applicant_name_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="phone_number_int"><b>Phone Number</b></label>
                                        <input type="text" class="form-control" id="phone_number_int"
                                            name="phone_number_int">
                                    </div>


                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="emailaddress"><b>Email Address</b></label>
                                        <input type="text" class="form-control" id="emailaddress" name="emailaddress">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="date_of_birth_int"><b>Date of Birth</b></label>
                                        <input type="date" class="form-control" id="date_of_birth_int"
                                            name="date_of_birth_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_admission_int"><b>Year of Admission</b></label>
                                        <input type="text" class="form-control" id="year_of_admission_int"
                                            name="year_of_admission_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_completion_int"><b>Year of Completion</b></label>
                                        <input type="text" class="form-control" id="year_of_completion_int"
                                            name="year_of_completion_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="institution_int"><b>Name of Institution(Optional)</b></label>
                                        <input type="text" placeholder="" class="form-control" id="institution_int"
                                            name="institution_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="institution_address"><b>Institutional Email(Optional)</b></label>
                                        <input type="text" placeholder="" class="form-control" id="institution_address"
                                            name="institution_address">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="program_int"><b>Programmes</b></label>
                                        <select class="form-control select program mr-2" name="program_int"
                                            id="program_int" required>
                                            <?php   foreach ($programmes as $key => $value):?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="delivery_mode_int"><b>Delivery Mode</b></label>
                                        <input type="text" class="form-control" id="delivery_mode_int"
                                            name="delivery_mode_int">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="country_int"><b>Country</b></label>
                                        <select class="form-control select country mr-2" name="country_int"
                                            id="country_int" required>
                                            <?php   foreach ($countries as $key => $value):?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="zip_code_int"><b>Zip Code</b></label>
                                        <input type="text" placeholder="233" class="form-control" id="zip_code_int"
                                            name="zip_code_int">
                                    </div>
                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="state_int"><b>State</b></label>
                                        <input type="text" placeholder="" class="form-control" id="state_int"
                                            name="state_int">
                                    </div>

                                    <div class="col-lg-12 col-sm-12" style="margin-top: 10px;">
                                        <label for="postal_address_int"><b>Postal Address</b></label>
                                        <textarea type="text" class="form-control" id="postal_address_int" rows="8"
                                            name="postal_address_int" cols="4" rows="4"></textarea>
                                    </div>

                                    <div style="margin-top: 15px;">
                                        <button class="btn btn-primary text-white mr-2" type="button"
                                            onclick="showSummaryInternationDelivery()">Proceed</button>
                                        <button class="btn bg-secondary text-white" onclick="restart()">Back</button>

                                    </div>
                                </div>

                                <div id="hand-picked">
                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="index_no_handpicked"><b>Index Number</b></label>
                                        <input type="text" class="form-control" id="index_no_handpicked"
                                            name="index_no_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="applicant_name_handpicked"><b>Applicant Name</b></label>
                                        <input type="text" class="form-control" id="applicant_name_handpicked"
                                            name="applicant_name_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="phone_number_handpicked"><b>Phone Number</b></label>
                                        <input type="text" class="form-control" id="phone_number_handpicked"
                                            name="phone_number_handpicked">
                                    </div>


                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="emailaddress_handpicked"><b>Email Address</b></label>
                                        <input type="text" class="form-control" id="emailaddress_handpicked"
                                            name="emailaddress_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="date_of_birth_handpicked"><b>Date of Birth</b></label>
                                        <input type="date" class="form-control" id="date_of_birth_handpicked"
                                            name="date_of_birth_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_admission_handpicked"><b>Year of Admission</b></label>
                                        <input type="text" class="form-control" id="year_of_admission_handpicked"
                                            name="year_of_admission_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="year_of_completion_handpicked"><b>Year of Completion</b></label>
                                        <input type="text" class="form-control" id="year_of_completion_handpicked"
                                            name="year_of_completion_handpicked">
                                    </div>

                                    <div class="col-lg-6 col-sm-12" style="margin-top: 10px;">
                                        <label for="program_handpicked"><b>Programmes</b></label>
                                        <select class="form-control select program mr-2" name="program_handpicked"
                                            id="program_handpicked" required>
                                            <?php   foreach ($programmes as $key => $value):?>
                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                            <?php endforeach ?>
                                        </select>
                                    </div>

                                    <div class="col-lg-12 col-sm-12" style="margin-top: 10px;">
                                        <label for="postal_address_handpicked"><b>Postal Address</b></label>
                                        <textarea type="text" class="form-control" id="postal_address_handpicked"
                                            name="postal_address_handpicked" cols="4" rows="4"></textarea>
                                    </div>

                                    <div class="col-lg-6 col-sm-12">
                                        <div style="margin-top: 15px;">
                                            <button class="btn btn-primary text-white mr-2" type="button"
                                                onclick="showSummary()">Proceed</button>
                                            <button class="btn bg-secondary text-white"
                                                onclick="restart()">Back</button>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 col-sm-12"></div>
                                </div>


                        </form>
                    </div>
                </div>

            </div>
        </div>

        <div class="col-12" id="summary">
            <div class="card shadow">
                <div class="card-body">
                    <div class="col-12" style="margin-top: 10px;">
                        <table class="table table-striped" style="margin-top: 15px;" id="user-info">
                            <tbody id="summary-table">

                            </tbody>
                        </table>
                        <div>
                            <button id="submit-btn" class="btn btn-primary text-white mr-2" type="button"
                                onclick="submitInformation()">
                                <div id="submit-btn-label">
                                    Submit
                                </div>
                                <div id="submit-btn-spinner" class="spinner-border" role="status">
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </button>
                            <button class="btn btn-secondary" type="button" onclick="backPressed()">Previous</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!--/#main-slider-->

<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('public/assets/plugins/jQurey/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/jquery.printarea.js')); ?>"></script>
<script>
var url = '<?php echo e(URL::asset('public/assets/json/countries.json')); ?>';

let programs_ = [];
var currentStep = 1;
var numSteps = 3;

let user_information = [{
        key: 'Student Name',
        value: 'Samuel Saah'
    },
    {
        key: 'index Number',
        value: '0248534232'
    },
    {
        key: 'Email Address',
        value: 'ssaah08@gmail.com'
    },
    {
        key: 'Mobile Number',
        value: '0248635208'
    }
];

let tracking_no = generateUniqueId(10);

$(document).ready(function() {
    $("#verification").show();
    $("#enter-information").hide();
    $("#summary").hide();
    $("#transaction_id_verification").show();
    $("#index_number_verification").hide();
    $("#user-info").hide();
    $('#verify-transaction-id-spinner').hide();
    $('#verify-index-spinner').hide();
    $('#submit-btn-spinner').hide();
    var countriesSelect2 = $('#country');
    var countriesSelect2_ = $('#country_int');

    getPrograms();
    $.ajax({
        url: url,
        method: 'GET',
        success: function(countries) {
            let countries_ = Object.values(countries);
            countries_ = countries_.map(country => {
                return {
                    id: country['name'].toLowerCase(),
                    name: country['name']
                }
            });
            countries_.forEach((country, index) => {
                var option = new Option(country.name, country.name, true, true);
                countriesSelect2.append(option).trigger('change');
            })
            countries_.forEach((country, index) => {
                var option = new Option(country.name, country.name, true, true);
                countriesSelect2_.append(option).trigger('change');
            })
        }
    });

    let transaction_information = localStorage.getItem('transaction-information');
    let applicant_information = localStorage.getItem('applicant-information');

    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
        $("#transaction_id_verification").hide();
        $("#index_number_verification").hide();
        $("#enter-information").hide();
        $("#verification").show();
        $("#summary").hide();
        $("#transaction_id_verification").hide();
        let delivery_mode = document.getElementById('delivery_mode_handpicked');
        let document_type = transaction_information['fetched'].toLowerCase();

        if (document_type.includes("Hand Picked".toLowerCase())) {
            $("#hand-picked").show();
            $("#international-delivery").hide();
            $("#local-delivery").hide();
            if (delivery_mode != null) {
                delivery_mode.value = "Hand Picked";
            }
        } else if (document_type.includes("International Delivery".toLowerCase())) {
            $("#hand-picked").hide();
            $("#international-delivery").show();
            $("#local-delivery").hide();
            if (delivery_mode != null) {
                delivery_mode.value = "International Delivery";
            }
        } else if (document_type.includes("Local Delivery".toLowerCase())) {
            $("#hand-picked").hide();
            $("#international-delivery").hide();
            $("#local-delivery").show();
            if (delivery_mode != null) {
                delivery_mode.value = "Local Delivery";
            }
        } else {
            $("#hand-picked").hide();
            $("#international-delivery").hide();
            $("#local-delivery").show();
            if (delivery_mode != null) {
                delivery_mode.value = "Hand Picked";
            }
        }

        $("#summary").hide();
        $("#transaction_id_verification").hide();
        document.getElementById('document-title').innerText = transaction_information['fetched'];


        $("#index_number_verification").show();
    }

    if (applicant_information != null && applicant_information != '') {
        applicant_information = JSON.parse(applicant_information);
        $("#transaction_id_verification").hide();
        $("#index_number_verification").show();
        document.getElementById('index_number').value = applicant_information['indexno'];
        drawApplicantTable(applicant_information, transaction_information['fetched']);
    }
});

function backPressed() {
    let step = currentStep--;
    nextStep(step);
}

function nextStep(currentStep) {
    if (currentStep > numSteps) {
        currentStep = 1;
    }

    if (currentStep == 1) {
        $("#verification").show();
        $("#enter-information").hide();
        $("#summary").hide();
    } else if (currentStep == 2) {
        $("#verification").hide();
        $("#enter-information").show();
        $("#summary").hide();
    } else if (currentStep == 3) {
        $("#verification").hide();
        $("#enter-information").hide();
        $("#summary").show();
    }
    var stepper = document.getElementById('stepper1');
    var steps = stepper.getElementsByClassName('step');

    Array.from(steps).forEach((step, index) => {
        let stepNum = index + 1;
        if (stepNum === currentStep) {
            addClass(step, 'editing');
        } else {
            removeClass(step, 'editing');
        }
        if (stepNum < currentStep) {
            addClass(step, 'done');
        } else {
            removeClass(step, 'done');
        }
    });
}

function restart() {
    localStorage.setItem('transaction-information', '');
    localStorage.setItem('applicant-information', '');
    nextStep(1);
}


function thatIsMe() {
    let step = currentStep++;
    nextStep(step);
    setTimeout(() => {
        let transaction_information = localStorage.getItem('transaction-information');
        let applicant_information = localStorage.getItem('applicant-information');

        if (transaction_information != null && transaction_information != '') {
            transaction_information = JSON.parse(transaction_information);
            let delivery_mode = transaction_information['fetched'];
            if (delivery_mode.includes('Hand Picked')) {
                document.getElementById('delivery_mode_handpicked').value = "Hand Picked";
            } else if (delivery_mode.includes('International Deliverey')) {
                document.getElementById('delivery_mode_hand_int').value = "International Delivery";
            } else {
                document.getElementById('delivery_mode').value = "Local Delivery";
            }
        }
    }, 100);
}

function notMe() {
    
    let transaction_information = localStorage.getItem('transaction-information');
    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
        let type = transaction_information['fetched'];
        console.log(type);
        if (type.includes('Local Delivery')) {
            document.getElementById('index_no').value = "";
            document.getElementById('applicant_name').value = "";
            document.getElementById('phone_number').value = "";

            document.getElementById('index_no').disabled = false;
            document.getElementById('applicant_name').disabled = false;
            document.getElementById('phone_number').disabled = false;
            document.getElementById('delivery_mode').disabled = false;
            document.getElementById('date_of_birth').value = "";
        } else if (type.includes('International Delivery')) {
            document.getElementById('index_no_int').value = "";
            document.getElementById('applicant_name_int').value = "";
            document.getElementById('phone_number_int').value = "";
            document.getElementById('index_no_int').disabled = false;
            document.getElementById('applicant_name_int').disabled = false;
            document.getElementById('phone_number_int').disabled = false;
            document.getElementById('delivery_mode_int').disabled = false;
            document.getElementById('date_of_birth_int').value = "";
        } else if (type.includes('Hand Picked')) {
            document.getElementById('index_no_handpicked').value = "";
            document.getElementById('applicant_name_handpicked').value = "";
            document.getElementById('phone_number_handpicked').value = "";
            document.getElementById('index_no_handpicked').disabled = false;
            document.getElementById('applicant_name_handpicked').disabled = false;
            document.getElementById('phone_number_handpicked').disabled = false;
            document.getElementById('date_of_birth_handpicked').value = "";
        } else {
            document.getElementById('index_no').value = "";
            document.getElementById('applicant_name').value = "";
            document.getElementById('phone_number').value = "";
            document.getElementById('index_no').disabled = false;
            document.getElementById('applicant_name').disabled = false;
            document.getElementById('phone_number').disabled = false;
            document.getElementById('delivery_mode').disabled = false;
            document.getElementById('date_of_birth').value = "";
        }

        localStorage.setItem('applicant-information', '');
        let step = currentStep++;
        nextStep(step);

    }


}

function showSummaryLocalDelivery() {
    // let index_number = document.getElementById('index_no').value;
    // let applicant_name = document.getElementById('applicant_name').value;
    // let phone_number = document.getElementById('phone_number').value;
    // let contact_information = document.getElementById('postal_address').value;
    // let delivery_mode = document.getElementById('delivery_mode').value;
    // let country = document.getElementById('country').value;
    // let emailaddress = document.getElementById('emailaddress').value;
    // let date_of_birth = document.getElementById('date_of_birth').value;
    // let year_of_admission = document.getElementById('year_of_admission').value;
    // let year_of_completion = document.getElementById('year_of_completion').value;
    // let program = document.getElementById('program').value;

    let index_number = document.getElementById('index_no').value;
    if (index_number == "" || index_number == null) {
        displayMessageWhenEmpty('Index number');
        return;
    }
    let applicant_name = document.getElementById('applicant_name').value;
    if (applicant_name == "" || applicant_name == null) {
        displayMessageWhenEmpty('Applicant name');
        return;
    }
    let emailaddress = document.getElementById('emailaddress').value;
    if (emailaddress == "" || emailaddress == null) {
        displayMessageWhenEmpty('Email address');
        return;
    }
    let date_of_birth = document.getElementById('date_of_birth').value;
    if (date_of_birth == "" || date_of_birth == null) {
        displayMessageWhenEmpty('Date of birth');
        return;
    }
    let phone_number = document.getElementById('phone_number').value;
    if (phone_number == "" || phone_number == null) {
        displayMessageWhenEmpty('Phone number');
        return;
    }
    let contact_information = document.getElementById('postal_address').value;
    if (contact_information == "" || contact_information == null) {
        displayMessageWhenEmpty('Postal address');
        return;
    }
    let country = document.getElementById('country').value;
    if (country == "" || country == null) {
        displayMessageWhenEmpty('Country');
        return;
    }
    let state = "";

    let zip_code = "";

    let delivery_mode = document.getElementById('delivery_mode').value;
    if (delivery_mode == "" || delivery_mode == null) {
        displayMessageWhenEmpty('Delivery mode');
        return;
    }
    let year_of_admission = document.getElementById('year_of_admission').value;
    if (year_of_admission == "" || year_of_admission == null) {
        displayMessageWhenEmpty('Year of admission');
        return;
    }
    let year_of_completion = document.getElementById('year_of_completion').value;
    if (year_of_completion == "" || year_of_completion == null) {
        displayMessageWhenEmpty('Year of completion');
        return;
    }
    let program = document.getElementById('program').value;
    if (program == "" || program == null) {
        displayMessageWhenEmpty('Program');
        return;
    }
    let type_of_document = "";
    let transaction_information = localStorage.getItem('transaction-information');
    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
        type_of_document = transaction_information['fetched'];
    }

    let arr = [
        {
            id: 'tracking_no',
            key: 'Tracking Number',
            value: tracking_no
        },
        {
            id: 'index_number',
            key: 'Index Number',
            value: index_number
        },
        {
            id: 'applicant_name',
            key: 'Applicant Name',
            value: applicant_name
        },
        {
            id: 'phone_number',
            key: 'Phone Number',
            value: phone_number
        },
        {
            id: 'emailaddress',
            key: 'Email Address',
            value: emailaddress
        },
        {
            id: 'date_of_birth',
            key: 'Date of Birth',
            value: date_of_birth
        },
        {
            id: 'year_of_admission',
            key: 'Year of Admission',
            value: year_of_admission
        },
        {
            id: 'year_of_completion',
            key: 'Year of Completion',
            value: year_of_completion
        },
        {
            id: 'program',
            key: 'Program',
            value: program
        },
        {
            id: 'type_of_document',
            key: 'Type of Document',
            value: type_of_document
        },
        {
            id: 'delivery_mode',
            key: 'Delivery Mode',
            value: delivery_mode
        },
        {
            id: 'country',
            key: 'Country',
            value: country
        },
        {
            id: 'postal_address',
            key: 'Postal Address',
            value: contact_information
        },
    ];

    user_information = arr;
    renderTable(user_information);
    let step = currentStep++;
    nextStep(step);
    let document_details = {
        type: 'Local Delivery',
        user_information: user_information
    }

    document_details = JSON.stringify(document_details);
    localStorage.setItem('type_of_document', document_details);
}

function showSummaryInternationDelivery() {
    let index_number = document.getElementById('index_no_int').value;
    if (index_number == "" || index_number == null) {
        displayMessageWhenEmpty('Index number');
        return;
    }
    let applicant_name = document.getElementById('applicant_name_int').value;
    if (applicant_name == "" || applicant_name == null) {
        displayMessageWhenEmpty('Applicant name');
        return;
    }
    let emailaddress = document.getElementById('emailaddress_int').value;
    if (emailaddress == "" || emailaddress == null) {
        displayMessageWhenEmpty('Email address');
        return;
    }
    let date_of_birth = document.getElementById('date_of_birth_int').value;
    if (date_of_birth == "" || date_of_birth == null) {
        displayMessageWhenEmpty('Date of birth');
        return;
    }
    let phone_number = document.getElementById('phone_number_int').value;
    if (phone_number == "" || phone_number == null) {
        displayMessageWhenEmpty('Phone number');
        return;
    }
    let contact_information = document.getElementById('postal_address_int').value;
    if (contact_information == "" || contact_information == null) {
        displayMessageWhenEmpty('Postal address');
        return;
    }
    let country = document.getElmentById('country_int').value;
    if (country == "" || country == null) {
        displayMessageWhenEmpty('Country');
        return;
    }
    let state = document.getElementById('state_int').value;
    if (state == "" || state == null) {
        displayMessageWhenEmpty('State');
        return;
    }
    let zip_code = document.getElementById('zip_code_int').value;
    if (zip_code == "" || zip_code == null) {
        displayMessageWhenEmpty('Zip code');
        return;
    }
    let delivery_mode = document.getElementById('delivery_mode_int').value;
    if (delivery_mode == "" || delivery_mode == null) {
        displayMessageWhenEmpty('Delivery mode');
        return;
    }
    let year_of_admission = document.getElementById('year_of_admission_int').value;
    if (year_of_admission == "" || year_of_admission == null) {
        displayMessageWhenEmpty('Year of admission');
        return;
    }
    let year_of_completion = document.getElementById('year_of_completion_int').value;
    if (year_of_completion == "" || year_of_completion == null) {
        displayMessageWhenEmpty('Year of completion');
        return;
    }
    let program = document.getElementById('program_int').value;
    if (program == "" || program == null) {
        displayMessageWhenEmpty('Program');
        return;
    }
    let type_of_document = "";

    let transaction_information = localStorage.getItem('transaction-information');
    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
        type_of_document = transaction_information['fetched'];
    }

    let arr = [
        {
            id: 'tracking_no',
            key: 'Tracking Number',
            value: tracking_no
        },
        {
            id: 'index_number',
            key: 'Index Number',
            value: index_number
        },
        {
            id: 'applicant_name',
            key: 'Applicant Name',
            value: applicant_name
        },
        {
            id: 'phone_number',
            key: 'Phone Number',
            value: phone_number
        },
        {
            id: 'emailaddress',
            key: 'Email Address',
            value: emailaddress
        },
        {
            id: 'date_of_birth',
            key: 'Date of Birth',
            value: date_of_birth
        },
        {
            id: 'year_of_admission',
            key: 'Year of Admission',
            value: year_of_admission
        },
        {
            id: 'year_of_completion',
            key: 'Year of Completion',
            value: year_of_completion
        },
        {
            id: 'program',
            key: 'Program',
            value: program
        },
        {
            id: 'type_of_document',
            key: 'Type of Document',
            value: type_of_document
        },
        {
            id: 'country',
            key: 'Country',
            value: country
        },
        {
            id: 'state',
            key: 'State',
            value: state
        },
        {
            id: 'zip_code',
            key: 'Zip Code',
            value: zip_code
        },
        {
            id: 'delivery_mode',
            key: 'Delivery Mode',
            value: delivery_mode
        },
        {
            id: 'postal_address',
            key: 'Postal Address',
            value: contact_information
        },
    ]

    user_information = arr;
    renderTable(user_information);
    let step = currentStep++;
    nextStep(step);

    let user_information_ = JSON.stringify(user_information);
    let document_details = {
        type: 'International Delivery',
        user_information: user_information
    }

    document_details = JSON.stringify(document_details);

    localStorage.setItem('type_of_document', document_details);
}

function showSummary() {
    let index_number = document.getElementById('index_no_handpicked').value;
    if (index_number == "" || index_number == null) {
        displayMessageWhenEmpty('Index number');
        return;
    }
    let applicant_name = document.getElementById('applicant_name_handpicked').value;
    if (applicant_name == "" || applicant_name == null) {
        displayMessageWhenEmpty('Applicant name');
        return;
    }
    let phone_number = document.getElementById('phone_number_handpicked').value;
    if (phone_number == "" || phone_number == null) {
        displayMessageWhenEmpty('Phone number');
        return;
    }
    let contact_information = document.getElementById('postal_address_handpicked').value;
    if (contact_information == "" || contact_information == null) {
        displayMessageWhenEmpty('Postal address');
        return;
    }
    let emailaddress = document.getElementById('emailaddress_handpicked').value;
    if (emailaddress == "" || emailaddress == null) {
        displayMessageWhenEmpty('Email address');
        return;
    }
    let date_of_birth = document.getElementById('date_of_birth_handpicked').value;
    if (date_of_birth == "" || date_of_birth == null) {
        displayMessageWhenEmpty('Date of birth');
        return;
    }
    let year_of_admission = document.getElementById('year_of_admission_handpicked').value;
    if (year_of_admission == "" || year_of_admission == null) {
        displayMessageWhenEmpty('Year of admission');
        return;
    }
    let year_of_completion = document.getElementById('year_of_completion_handpicked').value;
    if (year_of_completion == "" || year_of_completion == null) {
        displayMessageWhenEmpty('Year of completion');
        return;
    }
    let program = document.getElementById('program_handpicked').value;
    let type_of_document = "";
    let transaction_information = localStorage.getItem('transaction-information');
    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
        type_of_document = transaction_information['fetched'];
    }
    let arr = [
        {
            id: 'tracking_no',
            key: 'Tracking Number',
            value: tracking_no
        },
        {
            id: 'index_number',
            key: 'Index Number',
            value: index_number
        },
        {
            id: 'applicant_name',
            key: 'Applicant Name',
            value: applicant_name
        },
        {
            id: 'phone_number',
            key: 'Phone Number',
            value: phone_number
        },
        {
            id: 'emailaddress',
            key: 'Email Address',
            value: emailaddress
        },
        {
            id: 'date_of_birth',
            key: 'Date of Birth',
            value: date_of_birth
        },
        {
            id: 'year_of_admission',
            key: 'Year of Admission',
            value: year_of_admission
        },
        {
            id: 'year_of_completion',
            key: 'Year of Completion',
            value: year_of_completion
        },
        {
            id: 'program',
            key: 'Program',
            value: program
        },
        {
            id: 'type_of_document',
            key: 'Type of Document',
            value: type_of_document
        },
        {
            id: 'delivery_mode',
            key: 'Delivery Mode',
            value: "Hand Picked"
        },
        {
            id: 'postal_address',
            key: 'Postal Address',
            value: contact_information
        }
    ]

    user_information = arr;
    renderTable(user_information);
    let step = currentStep++;
    nextStep(step);
    let document_details = {
        type: 'Hand Picked',
        user_information: user_information
    }

    document_details = JSON.stringify(document_details);

    localStorage.setItem('type_of_document', document_details);

}

/* get, set class, see https://ultimatecourses.com/blog/javascript-hasclass-addclass-removeclass-toggleclass */

function hasClass(elem, className) {
    return new RegExp(' ' + className + ' ').test(' ' + elem.className + ' ');
}

function addClass(elem, className) {
    if (!hasClass(elem, className)) {
        elem.className += ' ' + className;
    }
}

function removeClass(elem, className) {
    var newClass = ' ' + elem.className.replace(/[\t\r\n]/g, ' ') + ' ';
    if (hasClass(elem, className)) {
        while (newClass.indexOf(' ' + className + ' ') >= 0) {
            newClass = newClass.replace(' ' + className + ' ', ' ');
        }
        elem.className = newClass.replace(/^\s+|\s+$/g, '');
    }
}

function submitInformation() {
    let index_no = "";
    let applicant_name = "";
    let phone_no = "";
    let emailaddress = "";
    let date_of_birth = "";
    let year_of_admission = "";
    let year_of_completion = "";
    let program = "";
    let country = "";
    let zip_code = "";
    let state = "";
    let delivery_mode = "";
    let postal_address = "";

    let type_of_document = localStorage.getItem('type_of_document');
    if (type_of_document != null && type_of_document != '') {
        type_of_document = JSON.parse(type_of_document);
        delivery_mode = type_of_document.type;
        let user_information = type_of_document.user_information;

        let index_no_ = user_information.filter(info => info['id'] == 'index_number');
        if (index_no_.length > 0) {
            index_no = index_no_[0].value;
        }

        let applicant_name_ = user_information.filter(info => info['id'] == 'applicant_name');
        if (applicant_name_.length > 0) {
            applicant_name = applicant_name_[0].value;
        }

        let phone_no_ = user_information.filter(info => info['id'] == 'phone_number');
        if (phone_no_.length > 0) {
            phone_no = phone_no_[0].value;
        }

        let emailaddress_ = user_information.filter(info => info['id'] == 'emailaddress');
        if (emailaddress_.length > 0) {
            emailaddress = emailaddress_[0].value;
        }

        let date_of_birth_ = user_information.filter(info => info['id'] == 'date_of_birth');
        if (date_of_birth_.length > 0) {
            date_of_birth = date_of_birth_[0].value;
        }

        let country_ = user_information.filter(info => info['id'] == 'country');
        if (country_.length > 0) {
            country = country_[0].value;
        }

        let zip_code_ = user_information.filter(info => info['id'] == 'zip_code');
        if (zip_code_.length > 0) {
            zip_code = zip_code_[0].value;
        }

        let state_ = user_information.filter(info => info['id'] == 'state');
        if (state_.length > 0) {
            state = state_[0].value;
        }

        let delivery_mode_ = user_information.filter(info => info['id'] == 'delivery_mode');
        if (delivery_mode_.length > 0) {
            delivery_mode = delivery_mode_[0].value;
        }

        let postal_address_ = user_information.filter(info => info['id'] == 'postal_address');
        if (postal_address_.length > 0) {
            postal_address = postal_address_[0].value;
        }

        let year_of_admission_ = user_information.filter(info => info['id'] == 'year_of_admission');
        if (year_of_admission_.length > 0) {
            year_of_admission = year_of_admission_[0].value;
        }

        let year_of_completion_ = user_information.filter(info => info['id'] == 'year_of_completion');
        if (year_of_completion_.length > 0) {
            year_of_completion = year_of_completion_[0].value;
        }

        let program_ = user_information.filter(info => info['id'] == 'program');
        if (program_.length > 0) {
            program = program_[0].value;
        }
    }

    let status = "Ordered";
    let created_at = new Date();
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;

    let transaction_information = localStorage.getItem('transaction-information');
    let applicant_information = localStorage.getItem('applicant-information');
    if (transaction_information != null && transaction_information != '') {
        transaction_information = JSON.parse(transaction_information);
    }

    if (applicant_information != null && applicant_information != '') {
        applicant_information = JSON.parse(applicant_information);
    }

    let postData = {
        tracking_no: tracking_no,
        index_no: index_no,
        applicant_name: applicant_name,
        phone_no: phone_no,
        emailaddress: emailaddress,
        date_of_birth: date_of_birth,
        year_of_admission: year_of_admission,
        year_of_completion: year_of_completion,
        program: program,
        postal_address: postal_address,
        country: country,
        zip_code: zip_code,
        state: state,
        delivery_mode: delivery_mode,
        transaction_id: transaction_information['transaction_id'],
        type_of_document: transaction_information['fetched'],
        status: status,
        created_at: created_at,
        _token: csrfToken
    }

    Swal.fire({
        title: 'Info',
        text: 'Do you want to submit?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33'
    }).then((result) => {
        if (result.isConfirmed) {
            $('#submit-btn-label').hide();
            $('#submit-btn-spinner').show();
            document.getElementById('submit-btn').disabled = true;
            $.ajax({
                url: `<?php echo e(url('/order-document')); ?>`,
                method: 'POST',
                data: postData,
                success: function(result_) {
                    $('#submit-btn-label').show();
                    $('#submit-btn-spinner').hide();
                    document.getElementById('submit-btn').disabled = false;
                    if (result_) {
                        let transaction_details = localStorage.getItem('transaction-information');
                        if (transaction_details != '' && transaction_details != null) {
                            let post_body = {
                                transaction_details: transaction_details,
                                _token: csrfToken
                            }
                            $.ajax({
                                url: `<?php echo e(url('/save-transaction-details')); ?>`,
                                method: 'POST',
                                data: post_body,
                                success: function(result_) {

                                }
                            });
                        }

                        if (result_ == 'success') {
                            localStorage.setItem('applicant-information', '');
                            localStorage.setItem('transaction-information', '');
                        }

                        Swal.fire({
                            title: 'Info',
                            text: result_ == 'success' ?
                                'Document has been ordered successfully!' :
                                'Document could not be ordered',
                            icon: 'info',
                            confirmButtonText: 'Yes',
                            showCancelButton: true,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#1cc88a',
                            cancelButtonColor: '#d33'
                        });
                    }


                }
            });
        }
    });
}

function getPrograms() {
    var program = $('#program');
    var program_int = $('#program_int');
    var program_handpicked = $('#program_handpicked');

    $.ajax({
        url: `<?php echo e(url('/get-programs')); ?>`,
        method: 'GET',
        success: function(programs) {
            programs = JSON.parse(programs);
            programs_ = programs;
            programs.forEach((country, index) => {
                var option = new Option(country.name, country.name, true, true);
                program_int.append(option).trigger('change');
            })
            programs.forEach((country, index) => {
                var option = new Option(country.name, country.name, true, true);
                program_handpicked.append(option).trigger('change');
            })

            programs.forEach((country, index) => {
                var option = new Option(country.name, country.name, true, true);
                program.append(option).trigger('change');
            })
        }
    });
}

function displayMessageWhenEmpty(field) {
    Swal.fire({
        title: 'Info',
        text: `${field} field cannot be empty`,
        icon: 'error',
        confirmButtonText: 'Okay',
        confirmButtonColor: '#1cc88a',
    })
}

function generateUniqueId(len) {
    let characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    let result = "";
    for (let i = 0; i < len; i++) {
        result += characters.charAt((Math.random() * characters.length));
    }

    return result;
}

function getValue(key, data) {
    let value = data.filter(d => d['name'] == key);
    if (value.length > 0) {
        return value[0].value
    }
    return "";
}

function renderTable1(user_information_) {
    $('#user-info').show();
    $('#user_information_table td').parent().remove();
    user_information_.forEach((user_info, user_info_index) => {
        let tb = $('#user_information_table');
        let tr = $(`<tr id=""></tr>`);
        let key = $(`<td> <b>${user_info.key }</b></td>`);
        let value = $(`<td> ${user_info.value }</td>`);
        tr.append(key);
        tr.append(value);
        tb.append(tr);
    });
}

function renderTable(user_information_) {
    $('#summary-table td').parent().remove();
    user_information_.forEach((user_info, user_info_index) => {
        let tb = $('#summary-table');
        let tr = $(`<tr id=""></tr>`);
        let key = $(`<td> <b>${user_info.key }</b></td>`);
        let value = $(`<td> ${user_info.value }</td>`);
        tr.append(key);
        tr.append(value);
        tb.append(tr);
    });
}

function verifyApplicant() {
    let transaction_id = document.getElementById('transaction_id').value;
    if (transaction_id.trim() == "") {
        Swal.fire({
            title: 'Info',
            text: 'Enter a valid transaction id',
            icon: 'error',
            confirmButtonText: 'Okay',
            confirmButtonColor: '#1cc88a'

        })

        return;
    }
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let postData = {
        transaction_id: transaction_id,
        _token: csrfToken
    }
    $('#verify-transaction-id-label').hide();
    $('#verify-transaction-id-spinner').show();
    document.getElementById('transaction-id-btn').disabled = true;
    $.ajax({
        url: `<?php echo e(url('/verify-transaction-id')); ?>`,
        method: 'POST',
        data: postData,
        success: function(result_) {
            $('#verify-transaction-id-label').show();
            $('#verify-transaction-id-spinner').hide();
            document.getElementById('transaction-id-btn').disabled = false;
            if (result_ != 'failed') {
                if (result_['code']) {
                    if (result_['code'] == 'R0122') {
                        Swal.fire({
                            title: 'Info',
                            text: result_['msg'],
                            icon: result_,
                            confirmButtonText: 'Okay',
                            confirmButtonColor: '#1cc88a'

                        })
                    }
                    currentStep = 1;
                } else {
                    localStorage.setItem('transaction-information', JSON.stringify(result_));
                    let document_type = result_['fetched'];
                    if (document_type.includes("Hand Picked")) {
                        $("#hand-picked").show();
                        $("#international-delivery").hide();
                        $("#local-delivery").hide();
                    } else if (document_type.includes("International Delivery")) {
                        $("#hand-picked").hide();
                        $("#international-delivery").show();
                        $("#local-delivery").hide();
                    } else if (document_type.includes("Local Delivery")) {
                        $("#hand-picked").hide();
                        $("#international-delivery").hide();
                        $("#local-delivery").show();
                    } else {
                        $("#hand-picked").hide();
                        $("#international-delivery").show();
                        $("#local-delivery").show();
                    }

                    document.getElementById('document-title').innerText = result_['fetched'];
                    $("#verification").show();
                    $("#summary").hide();
                    $("#transaction_id_verification").hide();
                    $("#index_number_verification").show();
                }
            } else {
                document.getElementById('transaction_id').value = "";
                Swal.fire({
                    title: 'Info',
                    text: 'Transaction Id has been used already',
                    icon: 'info',
                    confirmButtonText: 'Okay',
                    confirmButtonColor: '#1cc88a'

                })
            }

        }
    });
}

function verifyIndexNumber() {
    let index_number = document.getElementById('index_number').value;
    if (index_number.trim() == "") {
        Swal.fire({
            title: 'Info',
            text: 'Index number field cannot be empty!',
            icon: 'error',
            confirmButtonText: 'Okay',
            confirmButtonColor: '#1cc88a'
        })
    }

    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    let postData = {
        index_number: index_number,
        _token: csrfToken
    }

    $('#verify-index-label').hide();
    $('#verify-index-spinner').show();
    document.getElementById('verify-index-btn').disabled = true;

    $.ajax({
        url: `<?php echo e(url('/verify-index-number')); ?>`,
        method: 'POST',
        data: postData,
        success: function(result_) {
            $('#verify-index-label').show();
            $('#verify-index-spinner').hide();
            document.getElementById('index_number').value = "";
            document.getElementById('verify-index-btn').disabled = false;
            result_ = JSON.parse(result_);
            if (result_['code']) {
                if (result_['code'] == 'R0122') {
                    Swal.fire({
                        title: 'Info',
                        text: result_['msg'],
                        icon: 'error',
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    })
                }
            } else {
                if (result_['success'] == 'false') {
                    Swal.fire({
                        title: 'Info',
                        text: 'Index Number Does Not Exists!',
                        icon: 'error',
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    })
                }

                if (result_['success'] == 'true') {
                    localStorage.setItem('applicant-information', JSON.stringify(result_['applicant']));
                    let transaction_details = localStorage.getItem('transaction-information');
                    let type = "Hand Picked";
                    if (transaction_details != null && transaction_details != '') {
                        transaction_details = JSON.parse(transaction_details);
                        type = transaction_details['fetched'];
                    }

                    drawApplicantTable(result_['applicant'], type);
                }
            }
        }
    });



}

function drawApplicantTable(applicant_information, type) {
    console.log(applicant_information);
    let name =
        `${applicant_information['othernames'] } ${applicant_information['surname']} ${applicant_information['middlename']}`;
    let index_number = applicant_information['indexno'];
    let phone_number = applicant_information['tel'];
    let programme = applicant_information['programme'];
    let program = programs_.filter(p => p['pcode'] == programme);
    if (program.length > 0) {
        program = program[0];
        programme = program['name'];
    }


    let date_of_birth = applicant_information['dob'];
    let dob_splitted = date_of_birth.split('/');
    let d_of_birth = `${dob_splitted[2]}-${dob_splitted[1]}-${dob_splitted[0]}`;
    
    if (type.includes('Local Delivery')) {
        document.getElementById('index_no').value = index_number;
        document.getElementById('applicant_name').value = name;
        document.getElementById('phone_number').value = phone_number;

        document.getElementById('index_no').disabled = true;
        document.getElementById('applicant_name').disabled = true;
        document.getElementById('phone_number').disabled = true;
        document.getElementById('delivery_mode').disabled = true;
        document.getElementById('date_of_birth').value = d_of_birth;
        document.getElementById('year_of_admission').value = applicant_information['yrOfAd'];
        document.getElementById('year_of_completion').value = "";
    } else if (type.includes('International Delivery')) {
        document.getElementById('index_no_int').value = index_number;
        document.getElementById('applicant_name_int').value = name;
        document.getElementById('phone_number_int').value = phone_number;
        document.getElementById('index_no_int').disabled = true;
        document.getElementById('applicant_name_int').disabled = true;
        document.getElementById('phone_number_int').disabled = true;
        document.getElementById('delivery_mode_int').disabled = true;
        document.getElementById('date_of_birth_int').value = d_of_birth;
        document.getElementById('year_of_admission_int').value = applicant_information['yrOfAd'];
        document.getElementById('year_of_completion_int').value = "";
    } else if (type.includes('Hand Picked')) {
        document.getElementById('index_no_handpicked').value = index_number;
        document.getElementById('applicant_name_handpicked').value = name;
        document.getElementById('phone_number_handpicked').value = phone_number;
        document.getElementById('index_no_handpicked').disabled = true;
        document.getElementById('applicant_name_handpicked').disabled = true;
        document.getElementById('phone_number_handpicked').disabled = true;
        document.getElementById('date_of_birth_handpicked').value = d_of_birth;
        document.getElementById('year_of_admission_handpicked').value = applicant_information['yrOfAd'];
        document.getElementById('year_of_completion_handpicked').value = "";
    } else {
        document.getElementById('index_no').value = index_number;
        document.getElementById('applicant_name').value = name;
        document.getElementById('phone_number').value = phone_number;
        document.getElementById('index_no').disabled = true;
        document.getElementById('applicant_name').disabled = true;
        document.getElementById('phone_number').disabled = true;
        document.getElementById('delivery_mode').disabled = true;
        document.getElementById('date_of_birth').value = d_of_birth;
        document.getElementById('year_of_admission').value = applicant_information['yrOfAd'];
        document.getElementById('year_of_completion').value = "";
    }

    let arr = [{
            key: 'Index Number',
            value: index_number
        },
        {
            key: 'Name',
            value: name
        },
        {
            key: 'Tel',
            value: phone_number
        },
        {
            key: 'Programme',
            value: programme
        },
        {
            key: 'Date of Birth',
            value: d_of_birth
        },
        {
            key: 'CGPA',
            value: applicant_information['cgpa']
        },
        {
            key: 'Year of Admission',
            value: applicant_information['yrOfAd']
        }
        
    ]
    renderTable1(arr);
}

function getToken() {
    $.ajax({
        url: `<?php echo e(url('/token')); ?>`,
        method: 'GET',
        success: function(token_) {
            token = token_;
        }
    });

}
</script>
<?php echo $__env->make('master_content', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>