<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.datatables.buttons.min.css')); ?>">

<?php $__env->startSection('content'); ?>
<section>
    <div class="col-12 m-5">
        <div class="row">
            <div class="col-lg-10 col-sm-12 ">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h2>System Users</h2>
                            <div>
                                <a class="btn btn-primary text-white" href="<?php echo route('create-system-user'); ?>">Add
                                    User</a>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <a href="<?php echo url('system-users'); ?>" class="btn btn-success text-white"><i
                                        class="fas fa-sync me-1"></i>Reload</a>
                            </div>
                        </div>
                        <table id="dataTable-1" class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email Address</th>
                                    <th>Designation</th>
                                    <th style="width: 100px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($system_users as $system_user) {
                                ?>
                                <tr>
                                    <td> <?php echo e($system_user['firstname']); ?> </td>
                                    <td><?php echo e($system_user['lastname']); ?> </td>
                                    <td><?php echo e($system_user['emailaddress']); ?></td>
                                    <td><?php echo e($system_user['designation_']); ?> </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <button class="btn btn-light mr-2 ms-2"
                                                onclick="editSystemUser(<?php echo e($system_user['id']); ?>)">
                                                <i class="align-middle" data-feather="edit"></i>
                                            </button>
                                            
                                            <button class="btn btn-light mr-2 ms-2"  onclick="setUserPrivillages(<?php echo e($system_user['id']); ?>)">
                                                <i class="align-middle" data-feather="shield"></i>
                                            </button>

                                            <button class="btn btn-light mr-2 ms-2"  onclick="assignPrograms(<?php echo e($system_user['id']); ?>)">
                                                <i class="align-middle" data-feather="archive"></i>
                                            </button>

                                            <button class="btn btn-light mr-2 ms-2" onclick="deleteSystemUser(<?php echo e($system_user['id']); ?>);">
                                                <i class="align-middle text-danger" data-feather="trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>

                                <?php }?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> <!-- Bordered table -->
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>

<script>
$(document).ready(function() {
    $('#dataTable-1').DataTable({
        dom: 'Bfrtip',
        buttons: [
            // 'copy', 'csv', 'excel', 'pdf', 'print'
            {
                extend: 'copy',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'pdf',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'csv',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'excel',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'print',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
        ]
    });

    $(function() {
        $('select').select2();
    });
});

function setUserPrivillages(id) {
    window.location = `<?php echo e(url('/set-user-privillages/${id}')); ?>`;
}

function editSystemUser(id) {
    window.location = `<?php echo e(url('/edit-system-user/${id}')); ?>`;
}


function assignProducts(id) {
    window.location = `<?php echo e(url('/assign-products/${id}')); ?>`;
}

function assignPrograms(id) {
    console.log(id);
    window.location = `<?php echo e(url('/assign-programs/${id}')); ?>`;
}

function deleteSystemUser(id) {

    
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    Swal.fire({
        title: 'Info',
        text: 'Do you want to delete?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/delete-system-user/${id}')); ?>`,
                method: 'GET',
                data: {},
                success: function(result_) {

                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'System user has been deleted successfully!' :
                            'Sysetm user could not be deleted',
                        icon: result_,
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    }).then((res) => {
                        if (res.isConfirmed) {
                            window.location.reload();
                        }
                    })
                }
            });

        } else if (result.isDenied) {
            Swal.fire('Changes are not saved', '', 'info')
        }

    })
}
</script>
<?php echo $__env->make('master_view', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>