<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Admin &amp; Dashboard Template based on Bootstrap 5">
    <meta name="author" content="AdminKit">
    <meta name="keywords"
        content="adminkit, bootstrap, bootstrap 5, admin, dashboard, template, responsive, css, sass, html, theme, front-end, ui kit, web">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="refresh" content="<?php echo e(config('session.lifetime') * 60); ?>">
    <link rel="icon" href="<?php echo e(asset('public/assets/img/htu_logo.png')); ?>">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <!-- <link rel="shortcut icon" href="img/icons/icon-48x48.png" /> -->

    <!-- <link rel="canonical" href="https://demo-basic.adminkit.io/" /> -->

    <title>HTU-DRS | Admin</title>

    <link href="<?php echo e(asset('public/assets/css/bootstrap/bootstrap.css')); ?> " rel="stylesheet">
    <link href="<?php echo e(asset('public/assets/css/app.css')); ?> " rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/sweetalert/sweetalert2.min.css')); ?> ">
    <link href="<?php echo e(asset('public/assets/css/fontawesome/all.min.css')); ?> " rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/dataTables.bootstrap4.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/select2/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.dataTables.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.datatables.buttons.min.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
</head>

<body>
    <div class="wrapper">
        <!-- 
        <aside class="sidebar-left border-right bg-white shadow" id="leftSidebar" data-simplebar>
            <a href="#" class="btn collapseSidebar toggle-btn d-lg-none text-muted ml-2 mt-3"
                data-toggle="toggle">
                <i class="fe fe-x"><span class="sr-only"></span></i>
            </a>
        </aside> -->

        <?php echo $__env->make('partials.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <main style="width: 100%;">
            <?php echo $__env->make('partials.toolbar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="main">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main> <!-- main -->
    </div>

    <script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/daterangepicker.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/jquery.stickOnScroll.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/tinycolor-min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/config.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/d3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/topojson.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datamaps.all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datamaps-zoomto.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datamaps.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/Chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/fontawesome/all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/select2/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/sweetalert/sweetalert2.all.min.js')); ?>"></script>
    <script>
    Chart.defaults.global.defaultFontFamily = base.defaultFontFamily;
    Chart.defaults.global.defaultFontColor = colors.mutedColor;
    </script>
    <script src="<?php echo e(asset('public/assets/js/gauge.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/jquery.sparkline.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/apexcharts.custom.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/app.js')); ?>"></script>
    <!-- <script src="<?php echo e(asset('public/js/jquery.PrintArea.js')); ?>"></script> -->
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.vfs_fonts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/datatables/jquery.datatables.buttons.print.min.js')); ?>"></script>

    <script>
        $(document).ready(function() {
        var csrfToken = $('[name="csrf_token"]').attr('content');
            
            setInterval(refreshToken, 3600000); // 1 hour 
            
            function refreshToken(){
                $.get('token').done(function(data){
                    csrfToken = data; // the new token
                });
            }

            setInterval(refreshToken, 3600000); // 1 hour 
    });
    </script>
</body>

</html>