<?php $__env->startSection('title', 'Nerve Tech Client Management System'); ?>

<?php $__env->startSection('content'); ?>  
  <div class="modal fade" id="addClientModal" tabindex="-1" role="dialog" aria-labelledby="addClientModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="addClientModalLabel">Add Client</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
        <form id="addClientForm">
            <div class="form-group">
              <label for="accountBalance">Account Balance (GHS)</label>
              <input type="number" class="form-control" id="accountBalance" name="accountBalance">
            </div>
            <div class="form-group">
              <label for="firstName">First Name</label>
              <input type="text" class="form-control" id="firstName" name="firstName">
            </div>
            <!-- Add more form fields here -->
            <div class="form-group">
              <label for="email">Email Address</label>
              <input type="email" class="form-control" id="email" name="email">
            </div>
            <div class="form-group">
              <label for="gps">GPS (Ghana Post Number)</label>
              <input type="text" class="form-control" id="gps" name="gps">
            </div>
            <div class="form-group">
              <label for="plan">Plan (Internet Package)</label>
              <select class="form-control" id="plan" name="plan">
                <option>Plan 1</option>
                <option>Plan 2</option>
                <!-- Add more options here -->
              </select>
            </div>
            <div class="form-group">
              <label for="expiryDate">Expiry Date</label>
              <input type="date" class="form-control" id="expiryDate" name="expiryDate">
            </div>
            <!-- <button type="submit" class="btn btn-primary">Submit</button> -->

            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>
          </form>
        </div>
        
      </div>
    </div>
  </div>


  <!-- <div class="modal fade" id="addClientModal" tabindex="-1" role="dialog" aria-labelledby="addClientModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="addClientModalLabel">Add Client</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form>
              <div class="form-group">
                <label for="accountBalance">Account Balance (GHS)</label>
                <input type="number" class="form-control" id="accountBalance">
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary">Save changes</button>
          </div>
        </div>
      </div>
  </div> -->

      <!-- Add this outside your table -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">Edit Client</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
               <div class="modal-body">
                  <form method="POST" action="" id="editForm">
                    <div class="form-group">
                      <label for="edit-accountBalance">Account Balance (GHS)</label>
                      <input type="number" class="form-control" id="edit-accountBalance" name="accountBalance">
                    </div>
                    <div class="form-group">
                      <label for="edit-firstName">First Name</label>
                      <input type="text" class="form-control" id="edit-firstName" name="firstName">
                    </div>
                    <!-- Add more form fields here -->
                    <div class="form-group">
                      <label for="edit-email">Email Address</label>
                      <input type="email" class="form-control" id="edit-email" name="email">
                    </div>
                    <div class="form-group">
                      <label for="edit-gps">GPS (Ghana Post Number)</label>
                      <input type="text" class="form-control" id="edit-gps" name="gps">
                    </div>
                    <div class="form-group">
                      <label for="edit-plan">Plan (Internet Package)</label>
                      <select class="form-control" id="edit-plan" name="plan">
                        <option>Plan 1</option>
                        <option>Plan 2</option>
                        <!-- Add more options here -->
                      </select>
                    </div>
                    <div class="form-group">
                      <label for="edit-expiryDate">Expiry Date</label>
                      <input type="date" class="form-control" id="edit-expiryDate" name="expiryDate">
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                      <button type="updateClient" class="btn btn-primary">Submit</button>
                    </div>
                  </form>
              </div>
        </div>
            </div>
        </div>
    </div>

    <!--  Body Wrapper -->
    <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">
      <!-- Sidebar Start -->
      <aside class="left-sidebar">
        <!-- Sidebar scroll-->
        <div>
          <div class="brand-logo d-flex align-items-center justify-content-between">
            <a href="./index.html" class="text-nowrap logo-img">
              <!-- <img src="../assets/images/logos/dark-logo.svg" width="180" alt="" /> -->
              <h3 style="color: black;">Nerve Tech</h3>
            </a>
            <div class="close-btn d-xl-none d-block sidebartoggler cursor-pointer" id="sidebarCollapse">
              <i class="ti ti-x fs-8"></i>
            </div>
          </div>
          <!-- Sidebar navigation-->
          <nav class="sidebar-nav scroll-sidebar" data-simplebar="">
            <ul id="sidebarnav">
              <li class="nav-small-cap">
                <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                <span class="hide-menu">Home</span>
              </li>
              <li class="sidebar-item">
                <a class="sidebar-link" href="./index.html" aria-expanded="false">
                  <span>
                    <i class="ti ti-layout-dashboard"></i>
                  </span>
                  <span class="hide-menu">Manage Client</span>
                </a>
              </li>
              
            </ul>

          </nav>
          <!-- End Sidebar navigation -->
        </div>
        <!-- End Sidebar scroll-->
      </aside>
      <!--  Sidebar End -->
      <!--  Main wrapper -->
      <div class="body-wrapper">
        <!--  Header Start -->
        <header class="app-header">
          <nav class="navbar navbar-expand-lg navbar-light">
            <ul class="navbar-nav">
              <li class="nav-item d-block d-xl-none">
                <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse" href="javascript:void(0)">
                  <i class="ti ti-menu-2"></i>
                </a>
              </li>
              <!-- <li class="nav-item">
                <a class="nav-link nav-icon-hover" href="javascript:void(0)">
                  <i class="ti ti-bell-ringing"></i>
                  <div class="notification bg-primary rounded-circle"></div>
                </a>
              </li> -->
            </ul>
            <div class="navbar-collapse justify-content-end px-0" id="navbarNav">
              <ul class="navbar-nav flex-row ms-auto align-items-center justify-content-end">
                <!-- <a href="https://adminmart.com/product/modernize-free-bootstrap-admin-dashboard/" target="_blank" class="btn btn-primary">Download Free</a> -->
                <li class="nav-item dropdown">
                  <a class="nav-link nav-icon-hover" href="javascript:void(0)" id="drop2" data-bs-toggle="dropdown"
                    aria-expanded="false">
                    <!-- <img src="../assets/images/profile/user-1.jpg" alt="" width="35" height="35" class="rounded-circle"> -->
                  </a>
                  <div class="dropdown-menu dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop2">
                    <div class="message-body">
                      <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                        <i class="ti ti-user fs-6"></i>
                        <p class="mb-0 fs-3">My Profile</p>
                      </a>
                      <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                        <i class="ti ti-mail fs-6"></i>
                        <p class="mb-0 fs-3">My Account</p>
                      </a>
                      <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                        <i class="ti ti-list-check fs-6"></i>
                        <p class="mb-0 fs-3">My Task</p>
                      </a>
                      <a href="./authentication-login.html" class="btn btn-outline-primary mx-3 mt-2 d-block">Logout</a>
                    </div>
                  </div>
                </li>
              </ul>
            </div>
          </nav>
        </header>
        <!--  Header End -->
        <div class="container-fluid">
          <!--  Row 1 -->
          <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    <div class="mb-3 mb-sm-0">
                      <h5 class="card-title fw-semibold">Manage Client</h5>
                    </div>
                    <div>
                      <!-- <select class="form-select">
                        <option value="1">March 2023</option>
                        <option value="2">April 2023</option>
                        <option value="3">May 2023</option>
                        <option value="4">June 2023</option>
                      </select> -->
                      <!-- Button trigger modal -->
                      <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addClientModal">
                        Add Client
                      </button>
                      <!-- <a class="btn btn-primary" data-toggle="modal" data-target="#addClientModal">Add Client</a> -->
                      <input type="file" id="excelFile" accept=".xlsx" style="display: none;" />
                      <a class="btn btn-primary" onclick="document.getElementById('excelFile').click();">Import Client</a>                  </div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-4">
              <div class="row">
                <div class="col-lg-12">
                  
                </div>
                <div class="col-lg-12">
                  
                </div>
              </div>
            </div>
          </div>

          <div class="row">

          


            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <h5 class="card-title fw-semibold mb-4">Clients</h5>
                  <div class="table-responsive">
                    <table class="table text-nowrap mb-0 align-middle">
                      <thead class="text-dark fs-4">
                        <tr>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Id</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Name</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Telephone No</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Email</h6>
                          </th>
                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Expiry Date</h6>
                          </th>

                          <th class="border-bottom-0">
                            <h6 class="fw-semibold mb-0">Action</h6>
                          </th>

                        </tr>
                      </thead>
                      <tbody>
                        <?php $__currentLoopData = $clients->reverse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td class="border-bottom-0"><h6 class="fw-semibold mb-0"><?php echo e($loop->iteration); ?></h6></td>
                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-1"><?php echo e($client->first_name); ?></h6>
                              <span class="fw-normal"><?php echo e($client->plan); ?></span>                          
                            </td>
                            <td class="border-bottom-0">
                              <p class="mb-0 fw-normal"><?php echo e($client->gps); ?></p>
                            </td>
                            <td class="border-bottom-0">
                              <div class="d-flex align-items-center gap-2">
                                <span class="badge bg-primary rounded-3 fw-semibold"><?php echo e($client->email); ?></span>
                              </div>
                            </td>
                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-0 fs-4"><?php echo e($client->expiry_date); ?></h6>
                            </td>
                            <td class="border-bottom-0">
                              <h6 class="fw-semibold mb-0 fs-4">
                                <div class="dropdown">
                                  <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Select Action
                                  </button>
                                  <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <!-- <a class="dropdown-item" href="/clients/<?php echo e($client->id); ?>/edit">Edit</a> -->
                                    <button type="button" class="dropdown-item edit-button" data-toggle="modal" data-target="#editModal" data-id="<?php echo e($client->id); ?>" data-first_name="<?php echo e($client->first_name); ?>" data-last_name="<?php echo e($client->last_name); ?>" data-email="<?php echo e($client->email); ?>" data-plan="<?php echo e($client->plan); ?>" data-gps="<?php echo e($client->gps); ?>" data-expiry_date="<?php echo e($client->expiry_date); ?>" data-url="<?php echo e(url('/clients')); ?>">
                                      Edit
                                    </button>
                                    <a class="dropdown-item" href="#">Remove</a>
                                    <a class="dropdown-item" href="#">Renew</a>
                                    <a class="dropdown-item" href="#">Receipts</a>
                                  </div>
                                </div>
                              </h6>
                            </td>
                          </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php echo e($clients->links()); ?>



                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div> 

          <div class="py-6 px-6 text-center">
          </div>
        </div>
      </div>
    </div>

<?php $__env->stopSection(); ?>

<!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
$(document).ready(function(){

    // const site_url = 'http://localhost/smsalert/';

    $("#addClientForm").on("submit", function(event){
      event.preventDefault();

      // Get CSRF token
      var csrfToken = $('meta[name="csrf-token"]').attr('content');

      var formData = $(this).serialize();

      // Add CSRF token to form data
      formData += '&_token=' + csrfToken;

      $.ajax({
        url: `<?php echo e(url('/add-client')); ?>`,
        type: "POST",
        data: formData,
        success: function(response){
          // handle success
          Swal.fire(
            'Success!',
            'Your form has been submitted.',
            'success'
          ).then((result) => {
            // Reload the page when the dialog is dismissed
            if (result.isConfirmed || result.isDismissed) {
              location.reload();
            }
          });

          // Create new table row
          // var newRow = `
          //   <tr>
          //     <td class="border-bottom-0"><h6 class="fw-semibold mb-0">1</h6></td>
          //     <td class="border-bottom-0">
          //       <h6 class="fw-semibold mb-1">${response.first_name}</h6>
          //       <span class="fw-normal">${response.plan}</span>                          
          //     </td>
          //     <td class="border-bottom-0">
          //       <p class="mb-0 fw-normal">${response.gps}</p>
          //     </td>
          //     <td class="border-bottom-0">
          //       <div class="d-flex align-items-center gap-2">
          //         <span class="badge bg-primary rounded-3 fw-semibold">${response.email}</span>
          //       </div>
          //     </td>
          //     <td class="border-bottom-0">
          //       <h6 class="fw-semibold mb-0 fs-4">${response.expiry_date}</h6>
          //     </td>
          //     <td class="border-bottom-0">
          //       <h6 class="fw-semibold mb-0 fs-4">
          //         <div class="dropdown">
          //           <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          //           Select Action
          //           </button>
          //           <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
          //             <button type="button" class="dropdown-item edit-button" data-toggle="modal" data-target="#editModal" data-id="<?php echo e($client->id); ?>" data-first_name="<?php echo e($client->first_name); ?>" data-last_name="<?php echo e($client->last_name); ?>" data-email="<?php echo e($client->email); ?>" data-plan="<?php echo e($client->plan); ?>" data-gps="<?php echo e($client->gps); ?>" data-expiry_date="<?php echo e($client->expiry_date); ?>" data-url="<?php echo e(url('/clients')); ?>">
          //               Edit
          //             </button>                      <a class="dropdown-item" href="#">Remove</a>
          //             <a class="dropdown-item" href="#">Renew</a>
          //             <a class="dropdown-item" href="#">Receipts</a>
          //           </div>
          //         </div>
          //       </h6>
          //     </td>
          //   </tr>
          // `;

          // // Prepend new row to table
          // $('table').prepend(newRow);

          // // Update index numbers
          // $('table tr:not(:first)').each(function(index) {
          //   $(this).find('td:first-child h6').text(index + 1);
          // });
        },
        error: function(jqXHR, textStatus, errorThrown){
          // handle error
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            text: 'Something went wrong!',
            footer: '<a href>Why do I have this issue?</a>'
          })
        }
      });
    });

    $('.edit-button').on('click', function() {
        var id = $(this).data('id');
        var url = $(this).data('url');
       
        $.ajax({
          url: `<?php echo e(url('/clients')); ?>/` + id + '/edit',
          type: 'GET',
          success: function(client) {
            $('#editForm').attr('action', `${url}/${client.id}`);
            $('#editForm').data('id', client.id);         
            $('#edit-accountBalance').val(client.account_balance);
            $('#edit-firstName').val(client.first_name);
            $('#edit-lastName').val(client.last_name);
            $('#edit-email').val(client.email);
            $('#edit-plan').val(client.plan);
            $('#edit-gps').val(client.gps);
            $('#edit-expiryDate').val(client.expiry_date);
          },
          error: function(jqXHR, textStatus, errorThrown) {
            console.log(textStatus, errorThrown);
          }
        });
    });


    $('#editForm').on('submit', function(e) {
      e.preventDefault();

      var csrfToken = $('meta[name="csrf-token"]').attr('content');

      var id = $(this).data('id');
      var url = $(this).attr('action');
      var data = $(this).serialize();

      data += '&_token=' + csrfToken;

      // console.log(data);
      // return;

      console.log(`<?php echo e(url('/clients')); ?>/` + id);

      $.ajax({
        url: `<?php echo e(url('/clients')); ?>/` + id,
        type: 'post',
        data: data,
        success: function(response) {
          // Handle success here, for example by updating the table or showing a success message
          console.log(response);
          //add sweet alert here
          Swal.fire(
            'Success!',
            'Your form has been submitted.',
            'success'
          )
        },
        error: function(jqXHR, textStatus, errorThrown) {
          console.log(textStatus, errorThrown);
        }
      });
    });

});
</script>
    
    



<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>