<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Admin &amp; Dashboard Template based on Bootstrap 5">
    <meta name="author" content="AdminKit">
    <meta name="keywords"
        content="adminkit, bootstrap, bootstrap 5, admin, dashboard, template, responsive, css, sass, html, theme, front-end, ui kit, web">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link rel="icon" href="<?php echo e(asset('public/assets/img/htu_logo.png')); ?>">
    <title>Transcript System | Login</title>

    <link href="<?php echo e(asset('public/assets/css/app.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
</head>

<body>
    <main class="d-flex w-100">
        <div class="container d-flex flex-column">
            <div class="row vh-100">
                <div class="col-sm-10 col-md-8 col-lg-6 mx-auto d-table h-100">
                    <div class="d-table-cell align-middle">

                        <div class="card">
                            <div class="card-body">
                                <div class="m-sm-4">
                                    <div class="text-center">
                                        <img src="<?php echo e(asset('public/assets/img/htu_logo.png')); ?> "
                                            alt="" class="img-fluid rounded-circle" width="132"
                                            height="132" />
                                        <h1 style="margin-top: 10px; font-size: 35px; font-weight: bold;"><span style="color: #1cc88a;">Admin</span> Login
                                            </h3>

                                            <?php if($login_error): ?>
                                            <div style="margin-top: 10px; margin-bottom: 10px;">
                                                <label
                                                    style="color: crimson; font-size: 14px; background-color: rgba(227, 43, 80, 0.286); border-radius: 5px; padding: 5px; margin-top: 10px; margin-bottom: 10px; text-transform:capitalize;">
                                                    <?php echo e($login_error); ?> </label>
                                            </div>
                                            <?php endif; ?>
                                    </div>
                                    <form action="<?php echo url('check-user'); ?>" method="POST">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="mb-3">
                                            <label class="form-label"><b>Email</b></label>
                                            <input class="form-control form-control-lg" type="email" name="emailaddress"
                                                id="emailaddress" placeholder="Enter your email" />
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label"><b>Password</b></label>
                                            <input class="form-control form-control-lg" type="password" name="password"
                                                id="password" placeholder="Enter your password" />
                                            <small>
                                                <a>Forgot password?</a>
                                            </small>
                                        </div>
                                        <div>
                                            <label class="form-check">
                                                <input class="form-check-input" type="checkbox" value="remember-me"
                                                    name="remember-me" checked>
                                                <span class="form-check-label">
                                                    Remember me next time
                                                </span>
                                            </label>
                                        </div>
                                        <div class="d-flex mt-3">
                                            <button type="submit" style="width: 100%; border-radius: 10px;" class="btn btn-lg btn-success p-2">Sign in</button>
                                            <!-- <button type="submit" class="btn btn-lg btn-primary">Sign in</button> -->
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </main>

    <script src="<?php echo e(asset('public/assets/js/app.js')); ?> "></script>

</body>

</html>