<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.dataTables.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('public/assets/css/datatables/jquery.datatables.buttons.min.css')); ?>">

<?php $__env->startSection('content'); ?>
<section>
    <div class="col-12 m-5">
        <div class="row">
            <div class="col-lg-10 col-sm-12 ">
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h2>Action Logs</h2>
                        </div>

                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div>
                                <a href="<?php echo url('action-logs'); ?>" class="btn btn-success text-white"><i
                                        class="fas fa-sync me-1"></i>Reload</a>
                            </div>
                        </div>
                        <table id="dataTable-1" class="table table-bordered table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><b>ID</b></th>
                                    <th>Name</th>
                                    <th>Description</th>
                                    <th>Created At</th>
                                    <!-- <th style="width: 100px;">Action</th> -->
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($action_logs as $action_log) {
                                ?>
                                <tr>
                                    <td><?php echo e($action_log['id']); ?> </td>
                                    <td> <?php echo e($action_log['name']); ?> </td>
                                    <td><?php echo e($action_log['description']); ?> </td>
                                    <td><?php echo e($action_log['created_at']); ?></td>
                                   
                                </tr>

                                <?php }?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> <!-- Bordered table -->
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<script src="<?php echo e(asset('public/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/datatables/jquery.dataTables.min.js')); ?>"></script>

<script>
$(document).ready(function() {
    $('#dataTable-1').DataTable({
        dom: 'Bfrtip',
        buttons: [
            // 'copy', 'csv', 'excel', 'pdf', 'print'
            {
                extend: 'copy',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'pdf',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'csv',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'excel',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
            {
                extend: 'print',
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4]
                }
            },
        ]
    });

    $(function() {
        $('select').select2();
    });
});

function setUserPrivillages(id) {
    window.location = `<?php echo e(url('/set-user-privillages/${id}')); ?>`;
}

function editSystemUser(id) {
    window.location = `<?php echo e(url('/edit-system-user/${id}')); ?>`;
}


function assignProducts(id) {
    window.location = `<?php echo e(url('/assign-products/${id}')); ?>`;
}

function deleteSystemUser(id) {

    
    const csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
    Swal.fire({
        title: 'Info',
        text: 'Do you want to delete?',
        icon: 'question',
        confirmButtonText: 'Yes',
        showCancelButton: true,
        cancelButtonText: 'No',
        confirmButtonColor: '#1cc88a',
        cancelButtonColor: '#d33',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            $.ajax({
                url: `<?php echo e(url('/delete-system-user/${id}')); ?>`,
                method: 'GET',
                data: {},
                success: function(result_) {

                    Swal.fire({
                        title: 'Info',
                        text: result_ == 'success' ?
                            'System user has been deleted successfully!' :
                            'Sysetm user could not be deleted',
                        icon: result_,
                        confirmButtonText: 'Okay',
                        confirmButtonColor: '#1cc88a'

                    }).then((res) => {
                        if (res.isConfirmed) {
                            window.location.reload();
                        }
                    })
                }
            });

        } else if (result.isDenied) {
            Swal.fire('Changes are not saved', '', 'info')
        }

    })
}
</script>
<?php echo $__env->make('master_view', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>