<!doctype html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo $__env->yieldContent('title','Nerve Tech Client Management System'); ?></title>
  <!-- <link rel="shortcut icon" type="image/png" href="<?php echo e(asset('images/logos/favicon.png')); ?>" /> -->
  <link rel="stylesheet" href="<?php echo e(asset('public/css/styles.min.css')); ?>" />
  <!-- Bootstrap CSS CDN -->
  <!-- <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css"> -->
  <style>
    .close {
      color: #aaa;
      float: right;
      font-size: 28px;
      font-weight: bold;
      border: none;
      background: none;
      outline: none;
    }
    
    .close:hover,
    .close:focus {
      color: black;
      text-decoration: none;
      cursor: pointer;
    }
    
    .close span {
      font-size: 1.5rem;
      vertical-align: middle;
    }
  </style>
    
</head>

<body>

     <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">
      <!-- Sidebar Start -->
      <aside class="left-sidebar">
        <!-- Sidebar scroll-->
        <div>
          <div class="brand-logo d-flex align-items-center justify-content-between">
            <a href="./index.html" class="text-nowrap logo-img">
              <!-- <img src="../assets/images/logos/dark-logo.svg" width="180" alt="" /> -->
              <h3 style="color: black;">Nerve Tech</h3>
            </a>
            <div class="close-btn d-xl-none d-block sidebartoggler cursor-pointer" id="sidebarCollapse">
              <i class="ti ti-x fs-8"></i>
            </div>
          </div>
          <!-- Sidebar navigation-->
          <nav class="sidebar-nav scroll-sidebar" data-simplebar="">
            <ul id="sidebarnav">
              <li class="nav-small-cap">
                <i class="ti ti-dots nav-small-cap-icon fs-4"></i>
                <span class="hide-menu">Home</span>
              </li>

              <li class="sidebar-item">
                <a class="sidebar-link" href="<?php echo e(url('/dashboard')); ?>" aria-expanded="false">
                  <span>
                    <i class="ti ti-layout-dashboard"></i>
                  </span>
                  <span  class="hide-menu">Dashboard</span>
                </a>
              </li>

              <li class="sidebar-item">
                <a class="sidebar-link" href="<?php echo e(url('/packages/1')); ?>" aria-expanded="false">
                  <span>
                    <i class="ti ti-layout-dashboard"></i>
                  </span>
                  <span  class="hide-menu">Data Plans</span>
                </a>
              </li>

              <li class="sidebar-item">

                <a class="sidebar-link" href="<?php echo e(url('/clients/1')); ?>" aria-expanded="false">
                  <span>
                    <i class="ti ti-layout-dashboard"></i>
                  </span>
                  <span  class="hide-menu">Manage Client</span>
                </a>
              </li>

              <li class="sidebar-item">
                <a class="sidebar-link" href="<?php echo e(url('/support-ticket')); ?>" aria-expanded="false">
                  <span>
                    <i class="ti ti-layout-dashboard"></i>
                  </span>
                  <span  class="hide-menu">Support Ticket</span>
                </a>
              </li>

               <li class="sidebar-item">

                  <a class="sidebar-link" href="<?php echo e(url('/finance')); ?>" aria-expanded="false">
                    <span>
                      <i class="ti ti-layout-dashboard"></i>
                    </span>
                    <span  class="hide-menu">Finance</span>
                  </a>
                </li>
              
            </ul>

          </nav>
          <!-- End Sidebar navigation -->
        </div>
        <!-- End Sidebar scroll-->
      </aside>
      <!--  Sidebar End -->
      <!--  Main wrapper -->
      <div class="body-wrapper">
        <!--  Header Start -->
        <header class="app-header">
          <nav class="navbar navbar-expand-lg navbar-light">
            <ul class="navbar-nav">
              <li class="nav-item d-block d-xl-none">
                <a class="nav-link sidebartoggler nav-icon-hover" id="headerCollapse" href="javascript:void(0)">
                  <i class="ti ti-menu-2"></i>
                </a>
              </li>
              <!-- <li class="nav-item">
                <a class="nav-link nav-icon-hover" href="javascript:void(0)">
                  <i class="ti ti-bell-ringing"></i>
                  <div class="notification bg-primary rounded-circle"></div>
                </a>
              </li> -->
            </ul>
            <div class="navbar-collapse justify-content-end px-0" id="navbarNav">
              <ul class="navbar-nav flex-row ms-auto align-items-center justify-content-end">
                <!-- <a href="https://adminmart.com/product/modernize-free-bootstrap-admin-dashboard/" target="_blank" class="btn btn-primary">Download Free</a> -->
                <li class="nav-item dropdown">
                  <a class="nav-link nav-icon-hover" href="javascript:void(0)" id="drop2" data-bs-toggle="dropdown"
                    aria-expanded="false">
                  
                  <img src="<?php echo e(asset('public/assets/images/profile/user-1.jpg')); ?>" alt="" width="35" height="35" class="rounded-circle">
                  </a>
                  <div class="dropdown-menu dropdown-menu-end dropdown-menu-animate-up" aria-labelledby="drop2">
                    <div class="message-body">
                      <a href="javascript:void(0)" class="d-flex align-items-center gap-2 dropdown-item">
                        <i class="ti ti-user fs-6"></i>
                        <p class="mb-0 fs-3">My Profile</p>
                      </a>
                      
                      
                      <a href="<?php echo e(url('/')); ?>" class="btn btn-outline-primary mx-3 mt-2 d-block">Logout</a>
                    </div>
                  </div>
                </li>
              </ul>
            </div>
          </nav>
        </header> 
        <!--  Header End -->
            <?php echo $__env->yieldContent('content'); ?>
      </div>
    </div>
   

<!-- Bootstrap JS and jQuery CDN -->
<script src="<?php echo e(asset('public/libs/jquery/dist/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/js/sidebarmenu.js')); ?>"></script>
<script src="<?php echo e(asset('public/js/app.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/libs/simplebar/dist/simplebar.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>

</html>