<?php $__env->startSection('title', 'Nerve Tech Client Management System'); ?>

<?php $__env->startSection('content'); ?>  

  <div class="page-wrapper" id="main-wrapper" data-layout="vertical" data-navbarbg="skin6" data-sidebartype="full"
      data-sidebar-position="fixed" data-header-position="fixed">
    
      <!--  Main wrapper -->
      <div class="" style="padding-top: calc(70px + 15px)">
        
       
        <div class="container-fluid">
          <!--  Row 1 -->    
          <div class="row">
            <div class="col-lg-12 d-flex align-items-stretch">
              <div class="card w-100">
                <div class="card-body p-4">
                  <div class="row">
                    <div class="col-md-6">
                      <h5 class="card-title fw-semibold mb-4">Financial Summary</h5>
                    </div>
                    <div class="col-md-6 d-flex justify-content-end">
                      <form id="calculateForm" class="mb-3">

                        <div class="input-group">
                        </div>

                        <div class="row">
                          <!-- Start date -->
                          <div class="col-md-6">
                            <label for="start_payment_date">Start  Date:</label>
                            <input type="date" id="start_payment_date" name="start_date" class="form-control">
                          </div>

                          <!-- End date -->
                          <div class="col-md-6">
                            <label for="end_payment_date">End  Date:</label>
                            <input type="date" id="end_payment_date" name="end_date" class="form-control">
                          </div>

                       
                        </div>

                        <!-- Button -->
                        <div class="row mt-3">
                          <div class="col-md-12 d-flex justify-content-end">
                            <button class="btn btn-primary">Calculate</button>
                          </div>
                        </div>
                      </form>
                    </div>
                  </div>

                          
                </div>
              </div>
            </div>
          </div>  

        <div class="row">
            <div class="col-lg-12 d-flex align-items-strech">
              <div class="card w-100">
                <div class="card-body">
                  <div class="row">
                    <div class="col-12 pull-right">
                      <button id="exportButton" class="btn btn-primary">Export to Excel/CSV</button>
                    </div>
                  <br>
                  <br>
                                    <br>
                  <br>
                  </div>
                  <div class="d-sm-flex d-block align-items-center justify-content-between mb-9">
                    
                    <div class="mb-3 mb-sm-0">
                      
                                              <div class="card-title" id="calculatedAmount" style="text-align: center;"></div>                    </div>

                    </div>
                    <div>
                  </div>
                  <!-- <div id="chart"></div> -->
                </div>
              </div>
            </div>

            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12">
                  
                </div>
                <div class="col-lg-12">
                  
                </div>
              </div>
            </div>
          </div>  
        </div>    
      </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> 
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>
    <script>
      $(document).ready(function() {
          $('#calculateForm').on('submit', function(e) {
            e.preventDefault();
            const start_date = $('input[name="start_date"]').val();
            const end_date = $('input[name="end_date"]').val();

            // Redirect to the search page
            $.ajax({
              url: `<?php echo e(url('/financial-summary')); ?>`,
              type: 'POST',
              data: {
                  //payment_date: payment_date,
                  start_date: start_date,
                  end_date: end_date,
                  _token: '<?php echo e(csrf_token()); ?>'
              },
              success: function(response) {
                  // display the search client in the table
                  console.log(response);
                  // display the calculated amount
                $('#calculatedAmount').text('Calculated Amount from ' + start_date + ' to ' + end_date + ' is: ' + (response.summary[0].total_amount ? 'GHC'+response.summary[0].total_amount : 'GHC0.00'));
                $('.table-responsive').remove();


                // create a table to display the payments
                let paymentsTable = '<div class="table-responsive"><table class="table text-nowrap mb-0 align-middle"><thead class="text-dark fs-4"><tr><th>ID</th><th>Client</th><th>Amount</th><th>Payment Date</th></tr></thead><tbody>';

                // populate the table with the payments data
                response.payments.forEach((payment,i) => {
                  paymentsTable += '<tr><td class="border-bottom-0"><h6 class="fw-semibold mb-0">' + (i + 1) + '</h6></td><td class="border-bottom-0"><h6 class="fw-semibold mb-0">' + payment.account_username + '</h6></td><td class="border-bottom-0"><h6 class="fw-semibold mb-0">' + payment.amount + '</h6></td><td class="border-bottom-0"><h6 class="fw-semibold mb-0">' + payment.payment_date + '</h6></td></tr>';
                });

                paymentsTable += '</tbody></table></div>';

                // display the payments table under the calculated amount
                $('#calculatedAmount').after(paymentsTable);


              },
              error: function(err) {
                  // Handle error here
              }
          });
          
          });

          document.getElementById('exportButton').addEventListener('click', function() {
              let table = document.querySelector('.table-responsive table');
              let wb = XLSX.utils.table_to_book(table, {sheet: "Sheet JS"});
              XLSX.writeFile(wb, 'payments.xlsx');
          });
        });

    </script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>